/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.schema.Index;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.Map;

public class NoPrefixForIndexes
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        for (SearchCluster cluster : context.model().getSearchClusters()) {
            if (!(cluster instanceof IndexedSearchCluster)) continue;
            IndexedSearchCluster sc = (IndexedSearchCluster)cluster;
            for (DocumentDatabase docDb : sc.getDocumentDbs()) {
                DerivedConfiguration sdConfig = docDb.getDerivedConfiguration();
                Schema schema = sdConfig.getSchema();
                for (ImmutableSDField immutableSDField : schema.allConcreteFields()) {
                    if (!immutableSDField.doesIndexing()) continue;
                    if (immutableSDField.getMatching().getAlgorithm().equals((Object)MatchAlgorithm.PREFIX)) {
                        this.failField(context, schema, immutableSDField);
                    }
                    for (Map.Entry<String, Index> e : immutableSDField.getIndices().entrySet()) {
                        if (!e.getValue().isPrefix()) continue;
                        this.failField(context, schema, immutableSDField);
                    }
                }
            }
        }
    }

    private void failField(Validation.Context context, Schema schema, ImmutableSDField field) {
        context.illegal("For " + schema + ", field '" + field.getName() + "': match/index:prefix is not supported for indexes.");
    }
}

