/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.producer;

import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class UserConfigRepo {
    private final Map<ConfigDefinitionKey, ConfigPayloadBuilder> userConfigsMap;

    public UserConfigRepo() {
        this.userConfigsMap = new LinkedHashMap<ConfigDefinitionKey, ConfigPayloadBuilder>();
    }

    public UserConfigRepo(Map<ConfigDefinitionKey, ConfigPayloadBuilder> map) {
        this.userConfigsMap = map;
    }

    public ConfigPayloadBuilder get(ConfigDefinitionKey key) {
        return this.userConfigsMap.get(key);
    }

    public void merge(UserConfigRepo newRepo) {
        for (Map.Entry<ConfigDefinitionKey, ConfigPayloadBuilder> entry : newRepo.userConfigsMap.entrySet()) {
            if (entry.getValue() == null) continue;
            ConfigDefinitionKey key = entry.getKey();
            if (this.userConfigsMap.containsKey(key)) {
                ConfigPayloadBuilder lhsBuilder = this.userConfigsMap.get(key);
                ConfigPayloadBuilder rhsBuilder = entry.getValue();
                lhsBuilder.override(rhsBuilder);
                continue;
            }
            this.userConfigsMap.put(key, entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.userConfigsMap.isEmpty();
    }

    public int size() {
        return this.userConfigsMap.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ConfigDefinitionKey key : this.userConfigsMap.keySet()) {
            sb.append(key.toString());
        }
        return sb.toString();
    }

    public Set<ConfigDefinitionKey> configsProduced() {
        return this.userConfigsMap.keySet();
    }
}

