/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;

public class ComplexFieldsWithStructFieldIndexesValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        for (SearchCluster cluster : context.model().getSearchClusters()) {
            if (cluster.isStreaming()) continue;
            for (SchemaInfo spec : cluster.schemas().values()) {
                ComplexFieldsWithStructFieldIndexesValidator.validateComplexFields(context, cluster.getClusterName(), spec.fullSchema());
            }
        }
    }

    private static void validateComplexFields(Validation.Context context, String clusterName, Schema schema) {
        String unsupportedFields = schema.allFields().filter(field -> ComplexFieldsWithStructFieldIndexesValidator.hasStructFieldsWithIndex(field)).map(ComplexFieldsWithStructFieldIndexesValidator::toString).collect(Collectors.joining(", "));
        if (!unsupportedFields.isEmpty()) {
            context.deployState().getDeployLogger().logApplicationPackage(Level.WARNING, String.format("For cluster '%s', schema '%s': The following complex fields have struct fields with 'indexing: index' which is not supported and has no effect: %s. Remove setting or change to 'indexing: attribute' if needed for matching.", clusterName, schema.getName(), unsupportedFields));
        }
    }

    private static boolean hasStructFieldsWithIndex(ImmutableSDField field) {
        return !field.isImportedField() && field.usesStructOrMap() && ComplexFieldsWithStructFieldIndexesValidator.hasStructFieldsWithIndex(field.getStructFields());
    }

    private static String toString(ImmutableSDField field) {
        return field.getName() + " (" + String.join((CharSequence)", ", ComplexFieldsWithStructFieldIndexesValidator.getStructFieldsWithIndex(field.getStructFields())) + ")";
    }

    private static boolean hasStructFieldsWithIndex(Collection<? extends ImmutableSDField> structFields) {
        return !ComplexFieldsWithStructFieldIndexesValidator.getStructFieldsWithIndex(structFields).isEmpty();
    }

    private static List<String> getStructFieldsWithIndex(Collection<? extends ImmutableSDField> structFields) {
        ArrayList<String> result = new ArrayList<String>();
        for (ImmutableSDField immutableSDField : structFields) {
            if (immutableSDField.wasConfiguredToDoIndexing()) {
                result.add(immutableSDField.getName());
            }
            result.addAll(ComplexFieldsWithStructFieldIndexesValidator.getStructFieldsWithIndex(immutableSDField.getStructFields()));
        }
        return result;
    }
}

