/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ResourceLimits;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.utils.Duration;
import java.util.Optional;
import org.w3c.dom.Element;

public class ClusterControllerConfig
extends AnyConfigProducer
implements FleetcontrollerConfig.Producer {
    private final String clusterName;
    private final ClusterControllerTuning tuning;
    private final ResourceLimits resourceLimits;

    private ClusterControllerConfig(TreeConfigProducer<?> parent, String clusterName, ClusterControllerTuning tuning, ResourceLimits resourceLimits) {
        super(parent, "fleetcontroller");
        this.clusterName = clusterName;
        this.tuning = tuning;
        this.resourceLimits = resourceLimits;
    }

    public void getConfig(FleetcontrollerConfig.Builder builder) {
        AbstractConfigProducerRoot root = this.getRoot();
        if (root instanceof VespaModel) {
            String zooKeeperAddress = root.getAdmin().getZooKeepersConfigProvider().getZooKeepersConnectionSpec();
            builder.zookeeper_server(zooKeeperAddress);
        } else {
            builder.zookeeper_server("");
        }
        builder.index(0);
        builder.cluster_name(this.clusterName);
        builder.fleet_controller_count(this.getChildren().size());
        this.tuning.initProgressTime.ifPresent(i -> builder.init_progress_time((int)i.getMilliSeconds()));
        this.tuning.transitionTime.ifPresent(t -> builder.storage_transition_time((int)t.getMilliSeconds()));
        this.tuning.maxPrematureCrashes.ifPresent(var -> builder.max_premature_crashes(var.intValue()));
        this.tuning.stableStateTimePeriod.ifPresent(var -> builder.stable_state_time_period((int)var.getMilliSeconds()));
        this.tuning.minDistributorUpRatio.ifPresent(arg_0 -> ((FleetcontrollerConfig.Builder)builder).min_distributor_up_ratio(arg_0));
        this.tuning.minStorageUpRatio.ifPresent(arg_0 -> ((FleetcontrollerConfig.Builder)builder).min_storage_up_ratio(arg_0));
        this.tuning.minSplitBits.ifPresent(arg_0 -> ((FleetcontrollerConfig.Builder)builder).ideal_distribution_bits(arg_0));
        this.tuning.minNodeRatioPerGroup.ifPresent(arg_0 -> ((FleetcontrollerConfig.Builder)builder).min_node_ratio_per_group(arg_0));
        this.tuning.maxGroupsAllowedDown.ifPresent(arg_0 -> ((FleetcontrollerConfig.Builder)builder).max_number_of_groups_allowed_to_be_down(arg_0));
        this.resourceLimits.getConfig(builder);
    }

    public ClusterControllerTuning tuning() {
        return this.tuning;
    }

    private record ClusterControllerTuning(Optional<Duration> initProgressTime, Optional<Duration> transitionTime, Optional<Long> maxPrematureCrashes, Optional<Duration> stableStateTimePeriod, Optional<Double> minDistributorUpRatio, Optional<Double> minStorageUpRatio, Optional<Integer> maxGroupsAllowedDown, Optional<Double> minNodeRatioPerGroup, Optional<Integer> minSplitBits) {
    }

    private static class ClusterControllerTuningBuilder {
        private final Optional<Double> minNodeRatioPerGroup;
        private final Optional<Duration> initProgressTime;
        private final Optional<Duration> transitionTime;
        private final Optional<Long> maxPrematureCrashes;
        private final Optional<Duration> stableStateTimePeriod;
        private final Optional<Double> minDistributorUpRatio;
        private final Optional<Double> minStorageUpRatio;
        private final Optional<Integer> minSplitBits;
        private final Optional<Integer> maxGroupsAllowedDown;

        ClusterControllerTuningBuilder(ModelElement tuning, Optional<Double> minNodeRatioPerGroup, Optional<Integer> bucketSplittingMinimumBits, int numberOfLeafGroups) {
            this.minSplitBits = bucketSplittingMinimumBits;
            this.minNodeRatioPerGroup = minNodeRatioPerGroup;
            if (tuning == null) {
                this.initProgressTime = Optional.empty();
                this.transitionTime = Optional.empty();
                this.maxPrematureCrashes = Optional.empty();
                this.stableStateTimePeriod = Optional.empty();
                this.minDistributorUpRatio = Optional.empty();
                this.minStorageUpRatio = Optional.empty();
                this.maxGroupsAllowedDown = Optional.empty();
            } else {
                this.initProgressTime = Optional.ofNullable(tuning.childAsDuration("init-progress-time"));
                this.transitionTime = Optional.ofNullable(tuning.childAsDuration("transition-time"));
                this.maxPrematureCrashes = Optional.ofNullable(tuning.childAsLong("max-premature-crashes"));
                this.stableStateTimePeriod = Optional.ofNullable(tuning.childAsDuration("stable-state-period"));
                this.minDistributorUpRatio = Optional.ofNullable(tuning.childAsDouble("min-distributor-up-ratio"));
                this.minStorageUpRatio = Optional.ofNullable(tuning.childAsDouble("min-storage-up-ratio"));
                this.maxGroupsAllowedDown = ClusterControllerTuningBuilder.maxGroupsAllowedDown(tuning, numberOfLeafGroups);
            }
        }

        private static Optional<Integer> maxGroupsAllowedDown(ModelElement tuning, int numberOfLeafGroups) {
            Double groupsAllowedDownRatio = tuning.childAsDouble("groups-allowed-down-ratio");
            if (groupsAllowedDownRatio != null) {
                if (groupsAllowedDownRatio < 0.0 || groupsAllowedDownRatio > 1.0) {
                    throw new IllegalArgumentException("groups-allowed-down-ratio must be between 0 and 1, got " + groupsAllowedDownRatio);
                }
                int maxGroupsAllowedDown = Math.max(1, (int)Math.floor(groupsAllowedDownRatio * (double)numberOfLeafGroups));
                return Optional.of(maxGroupsAllowedDown);
            }
            return Optional.empty();
        }

        private ClusterControllerTuning build() {
            return new ClusterControllerTuning(this.initProgressTime, this.transitionTime, this.maxPrematureCrashes, this.stableStateTimePeriod, this.minDistributorUpRatio, this.minStorageUpRatio, this.maxGroupsAllowedDown, this.minNodeRatioPerGroup, this.minSplitBits);
        }
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<ClusterControllerConfig> {
        private final String clusterName;
        private final ModelElement clusterElement;
        private final ResourceLimits resourceLimits;

        public Builder(String clusterName, ModelElement clusterElement, ResourceLimits resourceLimits) {
            this.clusterName = clusterName;
            this.clusterElement = clusterElement;
            this.resourceLimits = resourceLimits;
        }

        @Override
        protected ClusterControllerConfig doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element producerSpec) {
            ModelElement tuning = this.clusterElement.child("tuning");
            ModelElement clusterControllerTuning = null;
            Optional<Double> minNodeRatioPerGroup = Optional.of(deployState.featureFlags().minNodeRatioPerGroup());
            Optional<Integer> bucketSplittingMinimumBits = Optional.empty();
            if (tuning != null) {
                minNodeRatioPerGroup = Optional.ofNullable(tuning.childAsDouble("min-node-ratio-per-group"));
                bucketSplittingMinimumBits = Optional.ofNullable(tuning.childAsInteger("bucket-splitting.minimum-bits"));
                clusterControllerTuning = tuning.child("cluster-controller");
            }
            int numberOfLeafGroups = ((ContentCluster)ancestor).getRootGroup().getNumberOfLeafGroups();
            ClusterControllerTuning tuningConfig = new ClusterControllerTuningBuilder(clusterControllerTuning, minNodeRatioPerGroup, bucketSplittingMinimumBits, numberOfLeafGroups).build();
            return new ClusterControllerConfig(ancestor, this.clusterName, tuningConfig, this.resourceLimits);
        }
    }
}

