/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.api.OnnxModelOptions;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.embedding.BertBaseEmbedderConfig;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.component.Model;
import com.yahoo.vespa.model.container.component.TypedComponent;
import org.w3c.dom.Element;

public class BertEmbedder
extends TypedComponent
implements BertBaseEmbedderConfig.Producer {
    private final OnnxModelOptions onnxModelOptions;
    private final ModelReference modelRef;
    private final ModelReference vocabRef;
    private final Integer maxTokens;
    private final String transformerInputIds;
    private final String transformerAttentionMask;
    private final String transformerTokenTypeIds;
    private final String transformerOutput;
    private final Integer transformerStartSequenceToken;
    private final Integer transformerEndSequenceToken;
    private final String poolingStrategy;

    public BertEmbedder(ApplicationContainerCluster cluster, Element xml, DeployState state) {
        super("ai.vespa.embedding.BertBaseEmbedder", "model-integration", xml);
        Model model = Model.fromXml(state, xml, "transformer-model").orElseThrow();
        this.onnxModelOptions = new OnnxModelOptions(XML.getChildValue((Element)xml, (String)"onnx-execution-mode"), XML.getChildValue((Element)xml, (String)"onnx-interop-threads").map(Integer::parseInt), XML.getChildValue((Element)xml, (String)"onnx-intraop-threads").map(Integer::parseInt), XML.getChildValue((Element)xml, (String)"onnx-gpu-device").map(Integer::parseInt).map(OnnxModelOptions.GpuDevice::new));
        this.modelRef = model.modelReference();
        this.vocabRef = Model.fromXml(state, xml, "tokenizer-vocab").orElseThrow().modelReference();
        this.maxTokens = XML.getChildValue((Element)xml, (String)"max-tokens").map(Integer::parseInt).orElse(null);
        this.transformerInputIds = XML.getChildValue((Element)xml, (String)"transformer-input-ids").orElse(null);
        this.transformerAttentionMask = XML.getChildValue((Element)xml, (String)"transformer-attention-mask").orElse(null);
        this.transformerTokenTypeIds = XML.getChildValue((Element)xml, (String)"transformer-token-type-ids").orElse(null);
        this.transformerOutput = XML.getChildValue((Element)xml, (String)"transformer-output").orElse(null);
        this.transformerStartSequenceToken = XML.getChildValue((Element)xml, (String)"transformer-start-sequence-token").map(Integer::parseInt).orElse(null);
        this.transformerEndSequenceToken = XML.getChildValue((Element)xml, (String)"transformer-end-sequence-token").map(Integer::parseInt).orElse(null);
        this.poolingStrategy = XML.getChildValue((Element)xml, (String)"pooling-strategy").orElse(null);
        model.registerOnnxModelCost(cluster, this.onnxModelOptions);
    }

    public void getConfig(BertBaseEmbedderConfig.Builder b) {
        b.transformerModel(this.modelRef).tokenizerVocab(this.vocabRef);
        if (this.maxTokens != null) {
            b.transformerMaxTokens(this.maxTokens.intValue());
        }
        if (this.transformerInputIds != null) {
            b.transformerInputIds(this.transformerInputIds);
        }
        if (this.transformerAttentionMask != null) {
            b.transformerAttentionMask(this.transformerAttentionMask);
        }
        if (this.transformerTokenTypeIds != null) {
            b.transformerTokenTypeIds(this.transformerTokenTypeIds);
        }
        if (this.transformerOutput != null) {
            b.transformerOutput(this.transformerOutput);
        }
        if (this.transformerStartSequenceToken != null) {
            b.transformerStartSequenceToken(this.transformerStartSequenceToken.intValue());
        }
        if (this.transformerEndSequenceToken != null) {
            b.transformerEndSequenceToken(this.transformerEndSequenceToken.intValue());
        }
        if (this.poolingStrategy != null) {
            b.poolingStrategy(BertBaseEmbedderConfig.PoolingStrategy.Enum.valueOf((String)this.poolingStrategy));
        }
        this.onnxModelOptions.executionMode().ifPresent(value -> b.onnxExecutionMode(BertBaseEmbedderConfig.OnnxExecutionMode.Enum.valueOf((String)value)));
        this.onnxModelOptions.interOpThreads().ifPresent(arg_0 -> ((BertBaseEmbedderConfig.Builder)b).onnxInterOpThreads(arg_0));
        this.onnxModelOptions.intraOpThreads().ifPresent(arg_0 -> ((BertBaseEmbedderConfig.Builder)b).onnxIntraOpThreads(arg_0));
        this.onnxModelOptions.gpuDevice().ifPresent(value -> b.onnxGpuDevice(value.deviceNumber()));
    }
}

