/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import java.util.logging.Logger;

public class InfrastructureDeploymentValidator
extends Validator {
    private static final Logger log = Logger.getLogger(InfrastructureDeploymentValidator.class.getName());

    @Override
    public void validate(VespaModel model, DeployState deployState) {
        if (ApplicationId.global().tenant().equals((Object)model.applicationPackage().getApplicationId().tenant())) {
            return;
        }
        ConfigModelContext.ApplicationType applicationType = model.getAdmin().getApplicationType();
        if (applicationType != ConfigModelContext.ApplicationType.DEFAULT) {
            log.warning("Tenant %s is not allowed to use application type %s".formatted(new Object[]{model.applicationPackage().getApplicationId().toFullString(), applicationType}));
            throw new IllegalArgumentException("Tenant is not allowed to override application type");
        }
    }
}

