/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.model.api.PortInfo;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.text.Lowercase;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.Affinity;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.PortsMeta;
import com.yahoo.vespa.model.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class AbstractService
extends TreeConfigProducer<AnyConfigProducer>
implements Service {
    private HostResource hostResource = null;
    private int id = 0;
    private int basePort = 0;
    private List<Integer> ports = new ArrayList<Integer>();
    private String jvmOptions = "";
    private String preload = null;
    private final Map<String, Object> environmentVariables = new TreeMap<String, Object>();
    protected PortsMeta portsMeta = new PortsMeta();
    private final Map<String, Object> serviceProperties = new LinkedHashMap<String, Object>();
    private Optional<Affinity> affinity = Optional.empty();
    private boolean initialized = false;

    protected String defaultPreload() {
        return Defaults.getDefaults().underVespaHome("lib64/vespa/malloc/libvespamalloc.so");
    }

    public AbstractService(TreeConfigProducer<?> parent, String name) {
        super(parent, name);
        this.environmentVariables.put("VESPA_SILENCE_CORE_ON_OOM", true);
    }

    public AbstractService(String name) {
        this(null, name);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.hostResource != null) {
            this.hostResource.deallocateService(this);
        }
    }

    public static <SERVICE extends AbstractService> void distributeCpuSocketAffinity(Collection<SERVICE> services) {
        HashMap affinityMap = new HashMap();
        for (AbstractService service : services) {
            if (!affinityMap.containsKey(service.getHostResource())) {
                affinityMap.put(service.getHostResource(), new ArrayList());
            }
            int cpuSocket = ((List)affinityMap.get(service.getHostResource())).size();
            ((List)affinityMap.get(service.getHostResource())).add(service);
            service.setAffinity(new Affinity.Builder().cpuSocket(cpuSocket).build());
        }
    }

    private void initService(DeployState deployState, HostResource hostResource, int userPort) {
        if (this.initialized) {
            throw new IllegalStateException("Service '" + this.getConfigId() + "' already initialized.");
        }
        if (hostResource == null) {
            throw new IllegalArgumentException("No host found for service '" + this.getServiceName() + "'. The hostalias is probably missing from hosts.xml.");
        }
        this.id = this.getIndex(hostResource);
        this.ports = hostResource.allocateService(deployState.getDeployLogger(), this, this.getInstanceWantedPort(userPort));
        this.initialized = true;
        for (String envVar : deployState.getProperties().environmentVariables()) {
            this.addEnvironmentVariable(envVar);
        }
    }

    public void initService(DeployState deployState) {
        this.initService(deployState, this.hostResource, this.basePort);
    }

    @Override
    public int getWantedPort() {
        return 0;
    }

    private int getInstanceWantedPort(int userWantedPort) {
        int wantedPort = 0;
        if (userWantedPort == 0) {
            if (this.requiresWantedPort()) {
                wantedPort = this.getWantedPort();
            } else if (this.getWantedPort() > 0) {
                wantedPort = this.getWantedPort() + (this.getId() - 1) * this.getPortCount();
            }
        } else {
            wantedPort = userWantedPort;
        }
        return wantedPort;
    }

    @Override
    public boolean requiresWantedPort() {
        return false;
    }

    @Override
    public PortsMeta getPortsMeta() {
        return this.portsMeta;
    }

    @Override
    public int getRelativePort(int i) {
        if (this.ports.size() < 1) {
            throw new IllegalStateException("Requested port with offset " + i + " for service that has not reserved any ports: " + this);
        }
        if (i >= this.ports.size()) {
            throw new IllegalStateException("Requested port with offset " + i + " for service that only has reserved " + this.ports.size() + " ports: " + this);
        }
        return this.ports.get(i);
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        return Optional.empty();
    }

    @Override
    public String getServiceName() {
        return this.getServiceType() + (this.id == 1 ? "" : Integer.toString(this.id));
    }

    @Override
    public String getServiceType() {
        return Lowercase.toLowerCase((String)this.getShortClassName());
    }

    private String getShortClassName() {
        Class<?> myClass = this.getClass();
        Package myPackage = myClass.getPackage();
        return myClass.getName().substring(1 + myPackage.getName().length());
    }

    @Override
    public HostResource getHost() {
        return this.hostResource;
    }

    @Override
    public String getHostName() {
        return this.hostResource.getHostname();
    }

    public int getId() {
        return this.id;
    }

    protected int getIndex(HostResource host) {
        int i = 0;
        for (Service s : host.getServices()) {
            if (!s.getServiceType().equals(this.getServiceType()) || s == this) continue;
            ++i;
        }
        return i + 1;
    }

    @Override
    public ServiceInfo getServiceInfo() {
        LinkedHashSet<PortInfo> portInfos = new LinkedHashSet<PortInfo>();
        for (int i = 0; i < this.portsMeta.getNumPorts(); ++i) {
            portInfos.add(new PortInfo(this.ports.get(i).intValue(), new LinkedHashSet<String>(this.portsMeta.getTagsAt(i))));
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> prop : this.serviceProperties.entrySet()) {
            properties.put(prop.getKey(), prop.getValue().toString());
        }
        return new ServiceInfo(this.getServiceName(), this.getServiceType(), portInfos, properties, this.getConfigId(), this.getHostName());
    }

    public AbstractService setProp(String key, String value) {
        this.serviceProperties.put(key, value);
        return this;
    }

    public AbstractService setProp(String key, Integer value) {
        this.serviceProperties.put(key, value);
        return this;
    }

    public String getServicePropertyString(String key) {
        return this.getServicePropertyString(key, null);
    }

    @Override
    public String getServicePropertyString(String key, String defStr) {
        Object result = this.serviceProperties.get(key);
        return result == null ? defStr : result.toString();
    }

    @Override
    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public final void setJvmOptions(String args) {
        this.jvmOptions = args == null ? "" : args;
    }

    public final void appendJvmOptions(String args) {
        if (args != null && !"".equals(args)) {
            this.setJvmOptions(this.jvmOptions + AbstractService.getSeparator(this.jvmOptions) + args);
        }
    }

    private static String getSeparator(String current) {
        return "".equals(current) ? "" : " ";
    }

    public final void prependJvmOptions(String args) {
        if (args != null && !"".equals(args)) {
            this.setJvmOptions(args + AbstractService.getSeparator(this.jvmOptions) + this.jvmOptions);
        }
    }

    public String getPreLoad() {
        return this.preload != null ? this.preload : this.defaultPreload();
    }

    public void setPreLoad(String preload) {
        this.preload = preload;
    }

    public void setMMapNoCoreLimit(long noCoreLimit) {
        if (noCoreLimit >= 0L) {
            this.environmentVariables.put("VESPA_MMAP_NOCORE_LIMIT", noCoreLimit);
        } else {
            this.environmentVariables.remove("VESPA_MMAP_NOCORE_LIMIT");
        }
    }

    public void setCoreOnOOM(boolean coreOnOOM) {
        if (!coreOnOOM) {
            this.environmentVariables.put("VESPA_SILENCE_CORE_ON_OOM", true);
        } else {
            this.environmentVariables.remove("VESPA_SILENCE_CORE_ON_OOM");
        }
    }

    public void setNoVespaMalloc(String s) {
        this.environmentVariables.put("VESPA_USE_NO_VESPAMALLOC", s);
    }

    public void setVespaMalloc(String s) {
        this.environmentVariables.put("VESPA_USE_VESPAMALLOC", s);
    }

    public void setVespaMallocDebug(String s) {
        this.environmentVariables.put("VESPA_USE_VESPAMALLOC_D", s);
    }

    public void setVespaMallocDebugStackTrace(String s) {
        this.environmentVariables.put("VESPA_USE_VESPAMALLOC_DST", s);
    }

    private static String toEnvValue(Object o) {
        if (o instanceof Number || o instanceof Boolean) {
            return o.toString();
        }
        return "\"" + o.toString() + "\"";
    }

    public void addEnvironmentVariable(String nameAndValue) {
        int pos = nameAndValue.indexOf(61);
        this.environmentVariables.put(nameAndValue.substring(0, pos), nameAndValue.substring(pos + 1));
    }

    public void addEnvironmentVariable(String name, Object value) {
        this.environmentVariables.put(name, value);
    }

    @Override
    public Map<String, Object> getEnvVars() {
        return Collections.unmodifiableMap(this.environmentVariables);
    }

    public String getEnvStringForTesting() {
        return this.environmentVariables.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "=" + AbstractService.toEnvValue(e.getValue())).collect(Collectors.joining(" "));
    }

    public void setBasePort(int wantedPort) {
        this.basePort = wantedPort;
    }

    public void setHostResource(HostResource hostResource) {
        this.hostResource = hostResource;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public int getHealthPort() {
        return -1;
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        return new LinkedHashMap<String, String>();
    }

    public int getNumPortsAllocated() {
        return this.ports.size();
    }

    public HostResource getHostResource() {
        return this.hostResource;
    }

    @Override
    public Optional<Affinity> getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = Optional.ofNullable(affinity);
    }

    public String toString() {
        return this.getServiceName() + " on " + (this.getHost() == null ? "no host" : this.getHost().toString());
    }
}

