/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.QrConfig;
import com.yahoo.container.core.ContainerHttpConfig;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.LogctlSpec;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.application.validation.RestartConfigs;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.ComponentGroup;
import com.yahoo.vespa.model.container.component.ComponentsConfigGenerator;
import com.yahoo.vespa.model.container.component.DiscBindingsConfigGenerator;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import java.lang.invoke.StringConcatFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@RestartConfigs(value={QrStartConfig.class, QrConfig.class})
public abstract class Container
extends AbstractService
implements QrConfig.Producer,
ComponentsConfig.Producer,
JdiscBindingsConfig.Producer,
ContainerHttpConfig.Producer,
ContainerMbusConfig.Producer {
    public static final int BASEPORT = Defaults.getDefaults().vespaWebServicePort();
    public static final String SINGLENODE_CONTAINER_SERVICESPEC = "default_singlenode_container";
    private ContainerCluster<?> owner = null;
    private List<LogctlSpec> logctlSpecs = List.of();
    protected final TreeConfigProducer<?> parent;
    private final String name;
    private boolean requireSpecificPorts = true;
    private String clusterName = null;
    private Optional<String> hostResponseHeaderKey = Optional.empty();
    private final boolean retired;
    private final int index;
    private final boolean dumpHeapOnShutdownTimeout;
    private final double shutdownTimeoutS;
    private final ComponentGroup<Handler> handlers = new ComponentGroup((TreeConfigProducer<AnyConfigProducer>)this, "handler");
    private final ComponentGroup<Component<?, ?>> components = new ComponentGroup((TreeConfigProducer<AnyConfigProducer>)this, "components");
    private final JettyHttpServer defaultHttpServer;
    private ContainerServiceType myServiceType = null;
    protected int allocatedSearchPort = 0;
    protected int allocatedRpcPort = 0;
    protected int allocatedMessagingPort = 0;

    protected Container(TreeConfigProducer<?> parent, String name, int index, DeployState deployState) {
        this(parent, name, false, index, deployState);
    }

    protected Container(TreeConfigProducer<?> parent, String name, boolean retired, int index, DeployState deployState) {
        super(parent, name);
        this.name = name;
        this.parent = parent;
        this.retired = retired;
        this.index = index;
        this.dumpHeapOnShutdownTimeout = deployState.featureFlags().containerDumpHeapOnShutdownTimeout();
        this.shutdownTimeoutS = deployState.featureFlags().containerShutdownTimeout();
        this.defaultHttpServer = new JettyHttpServer("DefaultHttpServer", Container.containerClusterOrNull(parent), deployState);
        if (this.getHttp() == null) {
            this.addChild(this.defaultHttpServer);
        }
        this.addBuiltinHandlers();
        this.addChild(new SimpleComponent("com.yahoo.container.jdisc.ConfiguredApplication$ApplicationContext"));
        this.appendJvmOptions(this.jvmOmitStackTraceInFastThrowOption(deployState.featureFlags()));
        this.addEnvironmentVariable("VESPA_MALLOC_MMAP_THRESHOLD", "0x800000");
    }

    protected String jvmOmitStackTraceInFastThrowOption(ModelContext.FeatureFlags featureFlags) {
        return featureFlags.jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type.container);
    }

    void setOwner(ContainerCluster<?> owner) {
        this.owner = owner;
    }

    public boolean isRetired() {
        return this.retired;
    }

    public ComponentGroup<Handler> getHandlers() {
        return this.handlers;
    }

    public ComponentGroup<?> getComponents() {
        return this.components;
    }

    public final void addComponent(Component c) {
        this.components.addComponent(c);
    }

    public final void addSimpleComponent(String idSpec, String classSpec, String bundleSpec) {
        this.addComponent(new SimpleComponent(new ComponentModel(idSpec, classSpec, bundleSpec)));
    }

    public final void addHandler(Handler h) {
        this.handlers.addComponent(h);
    }

    public void setHostResponseHeaderKey(Optional<String> hostResponseheaderKey) {
        Objects.requireNonNull(hostResponseheaderKey, "HostResponseheaderKey cannot be null");
        this.hostResponseHeaderKey = hostResponseheaderKey;
    }

    public Http getHttp() {
        return this.parent instanceof ContainerCluster ? ((ContainerCluster)this.parent).getHttp() : null;
    }

    public JettyHttpServer getDefaultHttpServer() {
        return this.defaultHttpServer;
    }

    public final int index() {
        return this.index;
    }

    public void addBuiltinHandlers() {
    }

    @Override
    public void initService(DeployState deployState) {
        if (this.isInitialized()) {
            return;
        }
        super.initService(deployState);
        if (this.getHttp() == null) {
            this.initDefaultJettyConnector();
        }
    }

    private int getPort(ConnectorFactory connectorFactory) {
        return connectorFactory.getListenPort();
    }

    private void initDefaultJettyConnector() {
        this.defaultHttpServer.addConnector(new ConnectorFactory.Builder("SearchServer", this.getSearchPort()).build());
    }

    @Override
    public final String getServiceType() {
        if (this.myServiceType == null) {
            this.myServiceType = this.myServiceType();
        }
        return this.myServiceType.serviceName;
    }

    protected abstract ContainerServiceType myServiceType();

    public void setClusterName(String name) {
        this.clusterName = name;
    }

    @Override
    public int getWantedPort() {
        return this.requiresWantedPort() ? BASEPORT : 0;
    }

    public void useDynamicPorts() {
        this.requireSpecificPorts = false;
    }

    @Override
    public boolean requiresWantedPort() {
        return this.requireSpecificPorts && this.getHttp() == null;
    }

    @Override
    public int getPortCount() {
        int httpPorts = this.getHttp() != null ? 0 : 2;
        return httpPorts + this.numMessageBusPorts() + this.numRpcPorts();
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        if (start == 0) {
            start = BASEPORT;
        }
        int offset = 0;
        if (this.getHttp() == null) {
            this.allocatedSearchPort = this.requireSpecificPorts ? from.requirePort(start, "http") : from.allocatePort("http");
            this.portsMeta.on(offset++).tag("http").tag("query").tag("external").tag("state");
            from.allocatePort("http/1");
            this.portsMeta.on(offset++).tag("http").tag("external");
        } else if (!this.getHttp().getHttpServer().isEmpty()) {
            for (ConnectorFactory connectorFactory : this.getHttp().getHttpServer().get().getConnectorFactories()) {
                int port = this.getPort(connectorFactory);
                String name = "http/" + connectorFactory.getName();
                from.requirePort(port, name);
                if (offset == 0) {
                    this.portsMeta.on(offset++).tag("http").tag("query").tag("external").tag("state");
                    continue;
                }
                this.portsMeta.on(offset++).tag("http").tag("external");
            }
        }
        if (this.messageBusEnabled()) {
            this.allocatedMessagingPort = from.allocatePort("messaging");
            this.portsMeta.on(offset++).tag("rpc").tag("messaging");
        }
        if (this.rpcServerEnabled()) {
            this.allocatedRpcPort = from.allocatePort("rpc/admin");
            this.portsMeta.on(offset++).tag("rpc").tag("admin");
        }
    }

    public int getSearchPort() {
        if (this.getHttp() != null) {
            throw new AssertionError((Object)"getSearchPort must not be used when http section is present.");
        }
        return this.allocatedSearchPort;
    }

    protected int getRpcPort() {
        return this.allocatedRpcPort;
    }

    protected int numRpcPorts() {
        return this.rpcServerEnabled() ? 1 : 0;
    }

    private int getMessagingPort() {
        return this.allocatedMessagingPort;
    }

    protected int numMessageBusPorts() {
        return this.messageBusEnabled() ? 1 : 0;
    }

    @Override
    public int getHealthPort() {
        Http http = this.getHttp();
        if (http != null) {
            if (http.getHttpServer().isEmpty()) {
                return -1;
            }
            return this.getRelativePort(0);
        }
        return this.httpServerEnabled() ? this.getSearchPort() : -1;
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.of("PRELOAD=" + this.getPreLoad() + " exec ${VESPA_HOME}/libexec/vespa/vespa-wrapper vespa-start-container-daemon " + this.getJvmOptions() + " ");
    }

    public void getConfig(QrConfig.Builder builder) {
        builder.rpc((QrConfig.Rpc.Builder)new QrConfig.Rpc.Builder().enabled((boolean)this.rpcServerEnabled()).port((int)this.getRpcPort()).slobrokId((String)this.serviceSlobrokId())).filedistributor((QrConfig.Filedistributor.Builder)this.filedistributorConfig()).discriminator((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)(this.clusterName != null ? StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001."}, (String)this.clusterName) : ""), (String)this.name))).clustername((String)(this.clusterName != null ? this.clusterName : "")).nodeIndex((int)this.index).shutdown.dumpHeapOnTimeout(this.dumpHeapOnShutdownTimeout).timeout(this.shutdownTimeoutS);
    }

    public String getAssignedJvmOptions() {
        return super.getJvmOptions();
    }

    private String serviceSlobrokId() {
        return "vespa/service/" + this.getConfigId();
    }

    private QrConfig.Filedistributor.Builder filedistributorConfig() {
        QrConfig.Filedistributor.Builder builder = new QrConfig.Filedistributor.Builder();
        FileDistributionConfigProducer fileDistribution = this.getRoot().getFileDistributionConfigProducer();
        if (fileDistribution != null) {
            builder.configid(fileDistribution.getConfigProducer(this.getHost().getHost()).getConfigId());
        }
        return builder;
    }

    public void getConfig(ComponentsConfig.Builder builder) {
        builder.setApplyOnRestart(this.owner.getDeferChangesUntilRestart());
        builder.components.addAll(ComponentsConfigGenerator.generate(this.allEnabledComponents()));
    }

    private Collection<Component<?, ?>> allEnabledComponents() {
        ArrayList allComponents = new ArrayList();
        this.addAllEnabledComponents(allComponents, this);
        return Collections.unmodifiableCollection(allComponents);
    }

    private void addAllEnabledComponents(Collection<Component<?, ?>> allComponents, TreeConfigProducer<?> current) {
        for (AnyConfigProducer child : current.getChildren().values()) {
            if (!this.httpServerEnabled() && this.isHttpServer(child)) continue;
            if (child instanceof Component) {
                allComponents.add((Component)child);
            }
            if (!(child instanceof TreeConfigProducer)) continue;
            TreeConfigProducer t = (TreeConfigProducer)child;
            this.addAllEnabledComponents(allComponents, t);
        }
    }

    private boolean isHttpServer(AnyConfigProducer component) {
        return component instanceof JettyHttpServer;
    }

    public final void getConfig(JdiscBindingsConfig.Builder builder) {
        builder.handlers(DiscBindingsConfigGenerator.generate(this.handlers.getComponents()));
    }

    public void getConfig(ContainerHttpConfig.Builder builder) {
        this.hostResponseHeaderKey.ifPresent(arg_0 -> ((ContainerHttpConfig.Builder)builder).hostResponseHeaderKey(arg_0));
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        builder.port(this.getMessagingPort());
    }

    @Override
    public HashMap<String, String> getDefaultMetricDimensions() {
        HashMap<String, String> dimensions = new HashMap<String, String>();
        if (this.clusterName != null) {
            dimensions.put("clustername", this.clusterName);
        }
        return dimensions;
    }

    protected String prepareStopCommand(Duration timeout) {
        long rpcTimeoutSeconds = timeout.toSeconds() + 10L;
        String rpcParams = "-t " + rpcTimeoutSeconds + " tcp/localhost:" + this.getRpcPort() + " prepareStop d:" + timeout.toSeconds();
        return Defaults.getDefaults().underVespaHome("bin/vespa-rpc-invoke") + " " + rpcParams;
    }

    private boolean messageBusEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().messageBusEnabled();
    }

    private boolean httpServerEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().httpServerEnabled();
    }

    private boolean rpcServerEnabled() {
        return this.containerCluster().isPresent() && this.containerCluster().get().rpcServerEnabled();
    }

    protected Optional<ContainerCluster> containerCluster() {
        return Optional.ofNullable(Container.containerClusterOrNull(this.parent));
    }

    private static ContainerCluster containerClusterOrNull(AnyConfigProducer producer) {
        return producer instanceof ContainerCluster ? (ContainerCluster)producer : null;
    }

    void setLogctlSpecs(List<LogctlSpec> logctlSpecs) {
        this.logctlSpecs = logctlSpecs;
    }

    @Override
    public List<LogctlSpec> getLogctlSpecs() {
        return this.logctlSpecs;
    }
}

