/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.container.QrConfig;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ContainerRestartValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel currentModel, VespaModel nextModel, DeployState deployState) {
        boolean nodesUnchanged = currentModel.allocatedHosts().equals((Object)nextModel.allocatedHosts());
        boolean contentUnchanged = this.contentHostsOf(currentModel).equals(this.contentHostsOf(nextModel));
        ArrayList<ConfigChangeAction> actions = new ArrayList<ConfigChangeAction>();
        for (ContainerCluster containerCluster : nextModel.getContainerClusters().values()) {
            actions.addAll(containerCluster.getContainers().stream().filter(container -> ContainerRestartValidator.isExistingContainer(container, currentModel)).filter(container -> ContainerRestartValidator.shouldContainerRestartOnDeploy(container, nextModel)).map(container -> ContainerRestartValidator.createConfigChangeAction(cluster.id(), container, nextModel, nodesUnchanged, contentUnchanged)).toList());
        }
        return actions;
    }

    private Set<HostSpec> contentHostsOf(VespaModel model) {
        return model.allocatedHosts().getHosts().stream().filter(spec -> spec.membership().map(membership -> membership.cluster().type().isContent()).orElse(false)).collect(Collectors.toUnmodifiableSet());
    }

    private static ConfigChangeAction createConfigChangeAction(ClusterSpec.Id id, Container container, VespaModel model, boolean nodesUnchanged, boolean contentUnchanged) {
        boolean ignoreOnRedeploy = switch (model.getConfig(QrConfig.class, container.getConfigId()).restartOnInternalRedeploy()) {
            default -> throw new IncompatibleClassChangeError();
            case QrConfig.RestartOnInternalRedeploy.Enum.never -> true;
            case QrConfig.RestartOnInternalRedeploy.Enum.content_changes -> contentUnchanged;
            case QrConfig.RestartOnInternalRedeploy.Enum.node_changes -> nodesUnchanged;
            case QrConfig.RestartOnInternalRedeploy.Enum.always -> false;
        };
        return new VespaRestartAction(id, ContainerRestartValidator.createMessage(container), container.getServiceInfo(), ignoreOnRedeploy);
    }

    private static String createMessage(Container container) {
        return String.format("Container '%s' is configured to always restart on deploy.", container.getConfigId());
    }

    private static boolean shouldContainerRestartOnDeploy(Container container, VespaModel nextModel) {
        QrConfig config = nextModel.getConfig(QrConfig.class, container.getConfigId());
        return config.restartOnDeploy();
    }

    private static boolean isExistingContainer(Container container, VespaModel currentModel) {
        return currentModel.getService(container.getConfigId()).isPresent();
    }
}

