/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.application.validation.AbstractBundleValidator;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.w3c.dom.Document;

public class PublicApiBundleValidator
extends AbstractBundleValidator {
    @Override
    protected void validateManifest(DeployState state, JarFile jar, Manifest mf) {
        String nonPublicApiAttribute = mf.getMainAttributes().getValue("X-JDisc-Non-PublicApi-Import-Package");
        if (nonPublicApiAttribute == null) {
            return;
        }
        List<String> nonPublicApisUsed = Arrays.asList(nonPublicApiAttribute.split(","));
        if (!nonPublicApisUsed.isEmpty()) {
            this.log(state, Level.WARNING, "Jar file '%s' uses non-public Vespa APIs: %s", this.filename(jar), nonPublicApisUsed);
        }
    }

    @Override
    protected void validatePomXml(DeployState state, JarFile jar, Document pom) {
    }
}

