/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

public enum SummaryTransform {
    NONE("none"),
    ATTRIBUTE("attribute"),
    BOLDED("bolded"),
    DISTANCE("distance"),
    DYNAMICBOLDED("dynamicbolded"),
    DYNAMICTEASER("dynamicteaser"),
    POSITIONS("positions"),
    RANKFEATURES("rankfeatures"),
    SUMMARYFEATURES("summaryfeatures"),
    GEOPOS("geopos"),
    ATTRIBUTECOMBINER("attributecombiner"),
    MATCHED_ELEMENTS_FILTER("matchedelementsfilter"),
    MATCHED_ATTRIBUTE_ELEMENTS_FILTER("matchedattributeelementsfilter"),
    COPY("copy"),
    DOCUMENT_ID("documentid"),
    TOKENS("tokens"),
    ATTRIBUTE_TOKENS("attribute-tokens");

    private final String name;

    private SummaryTransform(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SummaryTransform bold() {
        return switch (this) {
            case NONE, BOLDED -> BOLDED;
            case DYNAMICBOLDED, DYNAMICTEASER -> DYNAMICBOLDED;
            default -> throw new IllegalArgumentException("Can not bold a '" + this + "' field.");
        };
    }

    public SummaryTransform unbold() {
        return switch (this) {
            case NONE, BOLDED -> NONE;
            case DYNAMICBOLDED -> DYNAMICTEASER;
            default -> this;
        };
    }

    public boolean isBolded() {
        return this == BOLDED || this == DYNAMICBOLDED;
    }

    public boolean isDynamic() {
        return this == BOLDED || this == DYNAMICBOLDED || this == DYNAMICTEASER;
    }

    public boolean isTeaser() {
        return this == DYNAMICBOLDED || this == DYNAMICTEASER;
    }

    public boolean isTokens() {
        return this == TOKENS || this == ATTRIBUTE_TOKENS;
    }

    public boolean isInMemory() {
        return switch (this) {
            case ATTRIBUTE, DISTANCE, POSITIONS, GEOPOS, RANKFEATURES, SUMMARYFEATURES, ATTRIBUTECOMBINER, MATCHED_ATTRIBUTE_ELEMENTS_FILTER -> true;
            default -> false;
        };
    }

    public String toString() {
        return this.name;
    }
}

