/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashMap;
import java.util.Map;

public class ValidateFieldTypes
extends Processor {
    public ValidateFieldTypes(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        String searchName = this.schema.getName();
        HashMap<String, DataType> seenFields = new HashMap<String, DataType>();
        this.verifySearchAndDocFields(searchName, seenFields);
        this.verifySummaryFields(searchName, seenFields);
    }

    protected final void verifySearchAndDocFields(String searchName, Map<String, DataType> seenFields) {
        this.schema.allFields().forEach(field -> {
            this.checkFieldType(searchName, "index field", field.getName(), field.getDataType(), seenFields);
            for (Map.Entry<String, Attribute> entry : field.getAttributes().entrySet()) {
                this.checkFieldType(searchName, "attribute", entry.getKey(), entry.getValue().getDataType(), seenFields);
            }
        });
    }

    protected final void verifySummaryFields(String searchName, Map<String, DataType> seenFields) {
        for (DocumentSummary summary : this.schema.getSummaries().values()) {
            for (SummaryField field : summary.getSummaryFields().values()) {
                if (field.hasUnresolvedType()) continue;
                this.checkFieldType(searchName, "summary field", field.getName(), field.getDataType(), seenFields);
            }
        }
    }

    private void checkFieldType(String searchName, String fieldDesc, String fieldName, DataType fieldType, Map<String, DataType> seenFields) {
        DataType seenType = seenFields.get(fieldName);
        if (seenType == null) {
            seenFields.put(fieldName, fieldType);
        } else if (!ValidateFieldTypes.compatibleTypes(seenType, fieldType)) {
            throw this.newProcessException(searchName, fieldName, "Incompatible types. Expected " + seenType.getName() + " for " + fieldDesc + " '" + fieldName + "', got " + fieldType.getName() + ".");
        }
    }

    private static boolean compatibleTypes(DataType seenType, DataType fieldType) {
        if ("tag".equals(seenType.getName())) {
            return "tag".equals(fieldType.getName()) || "WeightedSet<string>".equals(fieldType.getName());
        }
        if ("tag".equals(fieldType.getName())) {
            return "tag".equals(seenType.getName()) || "WeightedSet<string>".equals(seenType.getName());
        }
        if (seenType instanceof TensorDataType && fieldType instanceof TensorDataType) {
            return fieldType.isAssignableFrom(seenType);
        }
        return seenType.equals((Object)fieldType);
    }
}

