/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.config.content.core.StorDistributormanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.ContentNode;
import com.yahoo.vespa.model.content.DistributorCluster;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import java.util.Optional;
import org.w3c.dom.Element;

public class Distributor
extends ContentNode
implements StorDistributormanagerConfig.Producer {
    PersistenceEngine provider;

    Distributor(ModelContext.Properties properties, DistributorCluster parent, int distributionKey, Integer distributorBasePort, PersistenceEngine provider) {
        super(properties.featureFlags(), parent, parent.getClusterName(), StorageNode.rootFolder + parent.getClusterName() + "/distributor/" + distributionKey, distributionKey);
        this.provider = provider;
        if (distributorBasePort != null) {
            this.setBasePort(distributorBasePort);
        }
    }

    private int tuneNumDistributorStripes() {
        if (this.getHostResource() != null && !this.getHostResource().realResources().isUnspecified()) {
            int cores = (int)this.getHostResource().realResources().vcpu();
            if (cores <= 16) {
                return 1;
            }
            if (cores <= 64) {
                return 2;
            }
            return 4;
        }
        return 0;
    }

    @Override
    public void getConfig(StorServerConfig.Builder builder) {
        super.getConfig(builder);
        this.provider.getConfig(builder);
    }

    public void getConfig(StorDistributormanagerConfig.Builder builder) {
        builder.num_distributor_stripes(this.tuneNumDistributorStripes());
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.of("exec sbin/vespa-distributord -c $VESPA_CONFIG_ID");
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilder<Distributor, Distributor> {
        ModelElement clusterXml;
        PersistenceEngine persistenceProvider;

        public Builder(ModelElement clusterXml, PersistenceEngine persistenceProvider) {
            this.clusterXml = clusterXml;
            this.persistenceProvider = persistenceProvider;
        }

        @Override
        protected Distributor doBuild(DeployState deployState, TreeConfigProducer<Distributor> ancestor, Element producerSpec) {
            return new Distributor(deployState.getProperties(), (DistributorCluster)ancestor, new ModelElement(producerSpec).integerAttribute("distribution-key"), this.clusterXml.integerAttribute("distributor-base-port"), this.persistenceProvider);
        }
    }
}

