/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.schema.Schema;
import com.yahoo.vespa.documentmodel.FieldView;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class DocumentSummary
extends FieldView {
    private boolean fromDisk = false;
    private boolean omitSummaryFeatures = false;
    private List<String> inherited = new ArrayList<String>();
    private final Schema owner;

    public DocumentSummary(String name, Schema owner) {
        super(name);
        this.owner = owner;
    }

    public void setFromDisk(boolean fromDisk) {
        this.fromDisk = fromDisk;
    }

    public boolean isFromDisk() {
        return this.fromDisk;
    }

    public void setOmitSummaryFeatures(boolean value) {
        this.omitSummaryFeatures = value;
    }

    public boolean omitSummaryFeatures() {
        return this.omitSummaryFeatures;
    }

    public void add(SummaryField summaryField) {
        summaryField.addDestination(this.getName());
        super.add(summaryField);
    }

    public SummaryField getSummaryField(String name) {
        SummaryField field = (SummaryField)this.get(name);
        if (field != null) {
            return field;
        }
        if (this.inherited().isEmpty()) {
            return null;
        }
        for (DocumentSummary inheritedSummary : this.inherited()) {
            SummaryField inheritedField = inheritedSummary.getSummaryField(name);
            if (inheritedField == null) continue;
            return inheritedField;
        }
        return null;
    }

    public Map<String, SummaryField> getSummaryFields() {
        LinkedHashMap<String, SummaryField> allFields = new LinkedHashMap<String, SummaryField>(this.getFields().size());
        for (DocumentSummary inheritedSummary : this.inherited()) {
            if (inheritedSummary == null) continue;
            allFields.putAll(inheritedSummary.getSummaryFields());
        }
        for (Field field : this.getFields()) {
            allFields.put(field.getName(), (SummaryField)field);
        }
        return allFields;
    }

    public void purgeImplicits() {
        ArrayList<SummaryField> falseImplicits = new ArrayList<SummaryField>();
        for (SummaryField summaryField : this.getSummaryFields().values()) {
            if (summaryField.isImplicit()) continue;
            Iterator<SummaryField.Source> j = summaryField.sourceIterator();
            while (j.hasNext()) {
                SummaryField sourceField;
                String sourceName = j.next().getName();
                if (sourceName.equals(summaryField.getName()) || (sourceField = this.getSummaryField(sourceName)) == null || !sourceField.isImplicit()) continue;
                falseImplicits.add(sourceField);
            }
        }
        for (SummaryField field : falseImplicits) {
            this.remove(field.getName());
        }
    }

    public void addInherited(String inherited) {
        this.inherited.add(inherited);
    }

    public List<DocumentSummary> inherited() {
        return this.inherited.stream().map(name -> this.owner.getSummary((String)name)).toList();
    }

    public String toString() {
        return "document summary '" + this.getName() + "'";
    }

    public void validate(DeployLogger logger) {
        for (String inheritedName : this.inherited) {
            DocumentSummary inheritedSummary = this.owner.getSummary(inheritedName);
            if (inheritedSummary != null) continue;
            logger.logApplicationPackage(Level.WARNING, this + " inherits '" + inheritedName + "' but this is not present in " + this.owner);
        }
    }
}

