/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.schema.Index;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class TensorFieldProcessor
extends Processor {
    public TensorFieldProcessor(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            if (field.getDataType() instanceof TensorDataType) {
                if (validate) {
                    this.validateIndexingScripsForTensorField(field);
                    this.validateAttributeSettingForTensorField(field);
                    this.validateHnswIndexParametersRequiresIndexing(field);
                }
                this.processIndexSettingsForTensorField(field, validate);
                continue;
            }
            if (!(field.getDataType() instanceof CollectionDataType) || !validate) continue;
            this.validateDataTypeForCollectionField(field);
        }
    }

    private void validateIndexingScripsForTensorField(SDField field) {
        if (field.doesIndexing() && !this.isTensorTypeThatSupportsHnswIndex(field)) {
            this.fail(this.schema, field, "A tensor of type '" + this.tensorTypeToString(field) + "' does not support having an 'index'. Currently, only tensors with 1 indexed dimension supports that.");
        }
    }

    private boolean isTensorTypeThatSupportsHnswIndex(ImmutableSDField field) {
        TensorType type = ((TensorDataType)field.getDataType()).getTensorType();
        return type.dimensions().size() == 1 && ((TensorType.Dimension)type.dimensions().get(0)).isIndexed();
    }

    private boolean isTensorTypeThatSupportsDirectStore(ImmutableSDField field) {
        TensorType type = ((TensorDataType)field.getDataType()).getTensorType();
        for (TensorType.Dimension dim : type.dimensions()) {
            if (!dim.isMapped()) continue;
            return true;
        }
        return false;
    }

    private String tensorTypeToString(ImmutableSDField field) {
        return ((TensorDataType)field.getDataType()).getTensorType().toString();
    }

    private void validateAttributeSettingForTensorField(SDField field) {
        Attribute attribute;
        if (field.doesAttributing() && (attribute = field.getAttributes().get(field.getName())) != null && attribute.isFastSearch() && !this.isTensorTypeThatSupportsDirectStore(field)) {
            this.fail(this.schema, field, "An attribute of type 'tensor' cannot be 'fast-search'.");
        }
    }

    private void validateHnswIndexParametersRequiresIndexing(SDField field) {
        Index index = field.getIndex(field.getName());
        if (index != null && index.getHnswIndexParams().isPresent() && !field.doesIndexing()) {
            this.fail(this.schema, field, "A tensor that specifies hnsw index parameters must also specify 'index' in 'indexing'");
        }
    }

    private void processIndexSettingsForTensorField(SDField field, boolean validate) {
        if (!field.doesIndexing()) {
            return;
        }
        if (this.isTensorTypeThatSupportsHnswIndex(field)) {
            if (validate && !field.doesAttributing()) {
                this.fail(this.schema, field, "A tensor that has an index must also be an attribute.");
            }
            Index index = field.getIndex(field.getName());
            HnswIndexParams params = new HnswIndexParams();
            if (index != null) {
                params = params.overrideFrom(index.getHnswIndexParams());
            }
            field.getAttribute().setHnswIndexParams(params);
        }
    }

    private void validateDataTypeForCollectionField(SDField field) {
        if (((CollectionDataType)field.getDataType()).getNestedType() instanceof TensorDataType) {
            this.fail(this.schema, field, "A field with collection type of tensor is not supported. Use simple type 'tensor' instead.");
        }
    }
}

