/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.ValidationParameters;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.AccessControlFilterExcludeValidator;
import com.yahoo.vespa.model.application.validation.AccessControlFilterValidator;
import com.yahoo.vespa.model.application.validation.BundleValidator;
import com.yahoo.vespa.model.application.validation.CloudDataPlaneFilterValidator;
import com.yahoo.vespa.model.application.validation.CloudHttpConnectorValidator;
import com.yahoo.vespa.model.application.validation.CloudUserFilterValidator;
import com.yahoo.vespa.model.application.validation.ComplexFieldsWithStructFieldAttributesValidator;
import com.yahoo.vespa.model.application.validation.ComplexFieldsWithStructFieldIndexesValidator;
import com.yahoo.vespa.model.application.validation.ConstantValidator;
import com.yahoo.vespa.model.application.validation.ContainerInCloudValidator;
import com.yahoo.vespa.model.application.validation.DeploymentSpecValidator;
import com.yahoo.vespa.model.application.validation.EndpointCertificateSecretsValidator;
import com.yahoo.vespa.model.application.validation.JvmHeapSizeValidator;
import com.yahoo.vespa.model.application.validation.NoPrefixForIndexes;
import com.yahoo.vespa.model.application.validation.PublicApiBundleValidator;
import com.yahoo.vespa.model.application.validation.QuotaValidator;
import com.yahoo.vespa.model.application.validation.RankSetupValidator;
import com.yahoo.vespa.model.application.validation.RoutingSelectorValidator;
import com.yahoo.vespa.model.application.validation.RoutingValidator;
import com.yahoo.vespa.model.application.validation.SchemasDirValidator;
import com.yahoo.vespa.model.application.validation.SearchDataTypeValidator;
import com.yahoo.vespa.model.application.validation.SecretStoreValidator;
import com.yahoo.vespa.model.application.validation.StreamingValidator;
import com.yahoo.vespa.model.application.validation.UriBindingsValidator;
import com.yahoo.vespa.model.application.validation.UrlConfigValidator;
import com.yahoo.vespa.model.application.validation.ValidationOverridesValidator;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.application.validation.change.CertificateRemovalChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ConfigValueChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ContainerRestartValidator;
import com.yahoo.vespa.model.application.validation.change.ContentClusterRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.ContentTypeRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.GlobalDocumentChangeValidator;
import com.yahoo.vespa.model.application.validation.change.IndexedSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.change.IndexingModeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.NodeResourceChangeValidator;
import com.yahoo.vespa.model.application.validation.change.RedundancyIncreaseValidator;
import com.yahoo.vespa.model.application.validation.change.ResourcesReductionValidator;
import com.yahoo.vespa.model.application.validation.change.StartupCommandChangeValidator;
import com.yahoo.vespa.model.application.validation.change.StreamingSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.first.RedundancyValidator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Validation {
    private final List<Validator> additionalValidators;

    public Validation() {
        this(List.of());
    }

    public Validation(List<Validator> additionalValidators) {
        this.additionalValidators = additionalValidators;
    }

    public List<ConfigChangeAction> validate(VespaModel model, ValidationParameters validationParameters, DeployState deployState) {
        if (validationParameters.checkRouting()) {
            new RoutingValidator().validate(model, deployState);
            new RoutingSelectorValidator().validate(model, deployState);
        }
        new SchemasDirValidator().validate(model, deployState);
        new BundleValidator().validate(model, deployState);
        new PublicApiBundleValidator().validate(model, deployState);
        new SearchDataTypeValidator().validate(model, deployState);
        new ComplexFieldsWithStructFieldAttributesValidator().validate(model, deployState);
        new ComplexFieldsWithStructFieldIndexesValidator().validate(model, deployState);
        new StreamingValidator().validate(model, deployState);
        new RankSetupValidator(validationParameters.ignoreValidationErrors()).validate(model, deployState);
        new NoPrefixForIndexes().validate(model, deployState);
        new ContainerInCloudValidator().validate(model, deployState);
        new DeploymentSpecValidator().validate(model, deployState);
        new ValidationOverridesValidator().validate(model, deployState);
        new ConstantValidator().validate(model, deployState);
        new SecretStoreValidator().validate(model, deployState);
        new EndpointCertificateSecretsValidator().validate(model, deployState);
        new AccessControlFilterValidator().validate(model, deployState);
        new QuotaValidator().validate(model, deployState);
        new UriBindingsValidator().validate(model, deployState);
        new CloudDataPlaneFilterValidator().validate(model, deployState);
        new AccessControlFilterExcludeValidator().validate(model, deployState);
        new CloudUserFilterValidator().validate(model, deployState);
        new CloudHttpConnectorValidator().validate(model, deployState);
        new UrlConfigValidator().validate(model, deployState);
        new JvmHeapSizeValidator().validate(model, deployState);
        this.additionalValidators.forEach(v -> v.validate(model, deployState));
        List<ConfigChangeAction> result = Collections.emptyList();
        if (deployState.getProperties().isFirstTimeDeployment()) {
            Validation.validateFirstTimeDeployment(model, deployState);
        } else {
            Optional<Model> currentActiveModel = deployState.getPreviousModel();
            if (currentActiveModel.isPresent() && currentActiveModel.get() instanceof VespaModel) {
                result = Validation.validateChanges((VespaModel)currentActiveModel.get(), model, deployState);
                Validation.deferConfigChangesForClustersToBeRestarted(result, model);
            }
        }
        return result;
    }

    private static List<ConfigChangeAction> validateChanges(VespaModel currentModel, VespaModel nextModel, DeployState deployState) {
        ChangeValidator[] validators = new ChangeValidator[]{new IndexingModeChangeValidator(), new GlobalDocumentChangeValidator(), new IndexedSearchClusterChangeValidator(), new StreamingSearchClusterChangeValidator(), new ConfigValueChangeValidator(), new StartupCommandChangeValidator(), new ContentTypeRemovalValidator(), new ContentClusterRemovalValidator(), new ResourcesReductionValidator(), new ResourcesReductionValidator(), new ContainerRestartValidator(), new NodeResourceChangeValidator(), new RedundancyIncreaseValidator(), new CertificateRemovalChangeValidator(), new RedundancyValidator()};
        List<ConfigChangeAction> actions = Arrays.stream(validators).flatMap(v -> v.validate(currentModel, nextModel, deployState).stream()).toList();
        Map<ValidationId, Collection> disallowableActions = actions.stream().filter(action -> action.validationId().isPresent()).collect(Collectors.groupingBy(action -> (ValidationId)action.validationId().orElseThrow(), Collectors.mapping(ConfigChangeAction::getMessage, Collectors.toCollection(LinkedHashSet::new))));
        deployState.validationOverrides().invalid(disallowableActions, deployState.now());
        return actions;
    }

    private static void validateFirstTimeDeployment(VespaModel model, DeployState deployState) {
        new RedundancyValidator().validate(model, deployState);
    }

    private static void deferConfigChangesForClustersToBeRestarted(List<ConfigChangeAction> actions, VespaModel model) {
        Set clustersToBeRestarted = actions.stream().filter(action -> action.getType() == ConfigChangeAction.Type.RESTART).map(action -> action.clusterId()).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        for (ClusterSpec.Id clusterToRestart : clustersToBeRestarted) {
            ContentCluster contentCluster;
            ApplicationContainerCluster containerCluster = model.getContainerClusters().get(clusterToRestart.value());
            if (containerCluster != null) {
                containerCluster.setDeferChangesUntilRestart(true);
            }
            if ((contentCluster = model.getContentClusters().get(clusterToRestart.value())) == null) continue;
            contentCluster.setDeferChangesUntilRestart(true);
        }
    }
}

