/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.schema.document.TypedKey;
import com.yahoo.text.Lowercase;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SummaryField
extends Field
implements Cloneable,
TypedKey {
    private SummaryTransform transform;
    private VsmCommand vsmCommand = VsmCommand.NONE;
    private Set<Source> sources = new LinkedHashSet<Source>();
    private Set<String> destinations = new LinkedHashSet<String>();
    private boolean implicit = false;

    public SummaryField(String name, DataType type) {
        this(name, type, SummaryTransform.NONE);
    }

    public SummaryField(Field field) {
        this(field, SummaryTransform.NONE);
    }

    public SummaryField(Field field, SummaryTransform transform) {
        this(field.getName(), field.getDataType(), transform);
    }

    public SummaryField(String name, DataType type, SummaryTransform transform) {
        super(name, type);
        this.transform = transform;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setTransform(SummaryTransform transform) {
        this.transform = transform;
        if (SummaryTransform.DYNAMICTEASER.equals((Object)transform) || SummaryTransform.BOLDED.equals((Object)transform)) {
            this.setVsmCommand(VsmCommand.FLATTENJUNIPER);
        }
    }

    public SummaryTransform getTransform() {
        return this.transform;
    }

    public String getSourceField() {
        String sourceName = this.getName();
        if (!this.sources.isEmpty()) {
            sourceName = this.sources.iterator().next().getName();
        }
        return sourceName;
    }

    public void addSource(String name) {
        this.sources.add(new Source(name));
    }

    public void addSource(Source source) {
        this.sources.add(source);
    }

    public Iterator<Source> sourceIterator() {
        return this.sources.iterator();
    }

    public int getSourceCount() {
        return this.sources.size();
    }

    public Set<Source> getSources() {
        return this.sources;
    }

    public String getSingleSource() {
        if (this.sources.isEmpty()) {
            return this.getName();
        }
        return this.sources.iterator().next().getName();
    }

    public void addDestination(String name) {
        this.destinations.add(name);
    }

    public final void addDestinations(Iterable<String> names) {
        for (String name : names) {
            this.addDestination(name);
        }
    }

    public Set<String> getDestinations() {
        return this.destinations;
    }

    public String toString(Collection<?> collection) {
        StringBuilder buffer = new StringBuilder();
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            buffer.append(i.next().toString());
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public SummaryField mergeWith(SummaryField merge) {
        if (merge == null) {
            return this;
        }
        if (this.isImplicit()) {
            return merge;
        }
        if (merge.isImplicit()) {
            return this;
        }
        if (!merge.getName().equals(this.getName())) {
            throw new IllegalArgumentException(merge + " conflicts with " + this + ": different names");
        }
        if (merge.getTransform() != this.getTransform()) {
            throw new IllegalArgumentException(merge + " conflicts with " + this + ": different transforms");
        }
        if (!merge.getDataType().equals((Object)this.getDataType())) {
            throw new IllegalArgumentException(merge + " conflicts with " + this + ": different types");
        }
        this.setImplicit(false);
        if (!this.isHeadOf(this.sourceIterator(), merge.sourceIterator())) {
            if (this.isHeadOf(merge.sourceIterator(), this.sourceIterator())) {
                this.sources = new LinkedHashSet<Source>(merge.sources);
            } else {
                throw new IllegalArgumentException(merge + " conflicts with " + this + ": on source list must be the start of the other");
            }
        }
        this.destinations.addAll(merge.destinations);
        return this;
    }

    public boolean hasSource(String name) {
        if (this.sources.isEmpty() && name.equals(this.getName())) {
            return true;
        }
        for (Source s : this.sources) {
            if (!s.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isHeadOf(Iterator<?> full, Iterator<?> head) {
        while (head.hasNext()) {
            if (!full.hasNext()) {
                return false;
            }
            if (full.next().equals(head.next())) continue;
            return false;
        }
        return true;
    }

    private String getDestinationString() {
        StringBuilder destinationString = new StringBuilder("destinations(");
        for (String destination : this.destinations) {
            destinationString.append(destination).append(" ");
        }
        destinationString.append(")");
        return destinationString.toString();
    }

    public String toString() {
        return "summary field '" + this.getName() + "'";
    }

    public String toLocateString() {
        return "'summary " + this.getName() + " type " + Lowercase.toLowerCase((String)this.getDataType().getName()) + "' in '" + this.getDestinationString() + "'";
    }

    public SummaryField clone() {
        try {
            SummaryField clone = (SummaryField)super.clone();
            if (this.sources != null) {
                clone.sources = new LinkedHashSet<Source>(this.sources);
            }
            if (this.destinations != null) {
                clone.destinations = new LinkedHashSet<String>(this.destinations);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    public boolean hasExplicitSingleSource() {
        String sourceName;
        String fieldName = this.getName();
        if (fieldName.equals(sourceName = this.getSingleSource())) {
            return false;
        }
        if (sourceName.contains(".")) {
            return false;
        }
        return this.sources.size() <= 1;
    }

    public VsmCommand getVsmCommand() {
        return this.vsmCommand;
    }

    public void setVsmCommand(VsmCommand vsmCommand) {
        this.vsmCommand = vsmCommand;
    }

    public static enum VsmCommand {
        NONE("NONE"),
        FLATTENSPACE("FLATTENSPACE"),
        FLATTENJUNIPER("FLATTENJUNIPER");

        private final String cmd;

        private VsmCommand(String cmd) {
            this.cmd = cmd;
        }

        public String toString() {
            return this.cmd;
        }
    }

    public static class Source
    implements Serializable {
        private final String name;
        private boolean override = false;

        public Source(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setOverride(boolean override) {
            this.override = override;
        }

        public boolean getOverride() {
            return this.override;
        }

        public int hashCode() {
            return this.name.hashCode() + Boolean.valueOf(this.override).hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Source)) {
                return false;
            }
            Source other = (Source)obj;
            return this.name.equals(other.name) && this.override == other.override;
        }

        public String toString() {
            return "source field '" + this.name + "'";
        }
    }
}

