/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionConverter;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.InputExpression;
import com.yahoo.vespa.indexinglanguage.expressions.ScriptExpression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class IndexingInputs
extends Processor {
    public IndexingInputs(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        for (SDField field : this.schema.allConcreteFields()) {
            ScriptExpression script = field.getIndexingScript();
            if (script == null) continue;
            String fieldName = field.getName();
            script = (ScriptExpression)new DefaultToCurrentField(fieldName).convert((Expression)script);
            script = (ScriptExpression)new EnsureInputExpression(fieldName).convert((Expression)script);
            if (validate) {
                new VerifyInputExpression(this.schema, field).visit((Expression)script);
            }
            field.setIndexingScript(script);
        }
    }

    private static class DefaultToCurrentField
    extends ExpressionConverter {
        final String fieldName;

        DefaultToCurrentField(String fieldName) {
            this.fieldName = fieldName;
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof InputExpression && ((InputExpression)exp).getFieldName() == null;
        }

        protected Expression doConvert(Expression exp) {
            return new InputExpression(this.fieldName);
        }
    }

    private static class EnsureInputExpression
    extends ExpressionConverter {
        final String fieldName;

        EnsureInputExpression(String fieldName) {
            this.fieldName = fieldName;
        }

        protected boolean shouldConvert(Expression exp) {
            return exp instanceof StatementExpression;
        }

        protected Expression doConvert(Expression exp) {
            if (exp.requiredInputType() != null) {
                return new StatementExpression(new Expression[]{new InputExpression(this.fieldName), exp});
            }
            return exp;
        }
    }

    private class VerifyInputExpression
    extends ExpressionVisitor {
        private final Schema schema;
        private final SDField field;

        public VerifyInputExpression(Schema schema, SDField field) {
            this.schema = schema;
            this.field = field;
        }

        protected void doVisit(Expression exp) {
            if (!(exp instanceof InputExpression)) {
                return;
            }
            String referencedFieldName = ((InputExpression)exp).getFieldName();
            ImmutableSDField referencedField = this.schema.getField(referencedFieldName);
            if (referencedField == null || !referencedField.hasFullIndexingDocprocRights()) {
                IndexingInputs.this.fail(this.schema, this.field, "Indexing script refers to field '" + referencedFieldName + "' which is neither a field in " + this.schema.getDocument() + " nor a mutable attribute");
            }
        }
    }
}

