/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.config.FileReference;
import com.yahoo.config.ModelReference;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.UserConfigRepo;
import com.yahoo.path.Path;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.yolean.Exceptions;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class UserConfiguredFiles
implements Serializable {
    private final FileRegistry fileRegistry;
    private final DeployLogger logger;

    public UserConfiguredFiles(FileRegistry fileRegistry, DeployLogger logger) {
        this.fileRegistry = fileRegistry;
        this.logger = logger;
    }

    public <PRODUCER extends AnyConfigProducer> void register(PRODUCER producer) {
        UserConfigRepo userConfigs = producer.getUserConfigs();
        HashMap<Path, FileReference> registeredFiles = new HashMap<Path, FileReference>();
        for (ConfigDefinitionKey key : userConfigs.configsProduced()) {
            ConfigPayloadBuilder builder = userConfigs.get(key);
            try {
                this.register(builder, registeredFiles, key);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unable to register file specified in services.xml for config '" + key + "': " + Exceptions.toMessageString((Throwable)e));
            }
        }
    }

    private void register(ConfigPayloadBuilder builder, Map<Path, FileReference> registeredFiles, ConfigDefinitionKey key) {
        ConfigPayloadBuilder.MapBuilder map;
        ConfigPayloadBuilder.Array array;
        ConfigDefinition configDefinition = builder.getConfigDefinition();
        if (configDefinition == null) {
            this.logger.logApplicationPackage(Level.INFO, "Unable to find config definition " + key + ". Will not register files for file distribution for this config");
            return;
        }
        this.registerEntries(builder, registeredFiles, configDefinition.getFileDefs(), false);
        this.registerEntries(builder, registeredFiles, configDefinition.getPathDefs(), false);
        this.registerEntries(builder, registeredFiles, configDefinition.getOptionalPathDefs(), false);
        this.registerEntries(builder, registeredFiles, configDefinition.getModelDefs(), true);
        for (Map.Entry entry : configDefinition.getArrayDefs().entrySet()) {
            if (UserConfiguredFiles.isNotAnyFileType(((ConfigDefinition.ArrayDef)entry.getValue()).getTypeSpec().getType())) continue;
            array = builder.getArray((String)entry.getKey());
            this.registerFileEntries(array.getElements(), registeredFiles, "model".equals(((ConfigDefinition.ArrayDef)entry.getValue()).getTypeSpec().getType()));
        }
        for (Map.Entry entry : configDefinition.getLeafMapDefs().entrySet()) {
            if (UserConfiguredFiles.isNotAnyFileType(((ConfigDefinition.LeafMapDef)entry.getValue()).getTypeSpec().getType())) continue;
            map = builder.getMap((String)entry.getKey());
            this.registerFileEntries(map.getElements(), registeredFiles, "model".equals(((ConfigDefinition.LeafMapDef)entry.getValue()).getTypeSpec().getType()));
        }
        for (String name : configDefinition.getStructDefs().keySet()) {
            this.register(builder.getObject(name), registeredFiles, key);
        }
        for (String name : configDefinition.getInnerArrayDefs().keySet()) {
            array = builder.getArray(name);
            for (ConfigPayloadBuilder element : array.getElements()) {
                this.register(element, registeredFiles, key);
            }
        }
        for (String name : configDefinition.getStructMapDefs().keySet()) {
            map = builder.getMap(name);
            for (ConfigPayloadBuilder element : map.getElements()) {
                this.register(element, registeredFiles, key);
            }
        }
    }

    private static boolean isNotAnyFileType(String type) {
        return !"file".equals(type) && !"path".equals(type) && !"model".equals(type);
    }

    private void registerEntries(ConfigPayloadBuilder builder, Map<Path, FileReference> registeredFiles, Map<String, ?> entries, boolean isModelType) {
        for (Map.Entry<String, ?> entry : entries.entrySet()) {
            String name;
            ConfigPayloadBuilder fileEntry;
            if (UserConfiguredFiles.isEmptyOptionalPath(entry, fileEntry = builder.getObject(name = entry.getKey()))) continue;
            if (fileEntry.getValue() == null || fileEntry.getValue().equals(".")) {
                throw new IllegalArgumentException("Unable to register file for field '" + name + "': Invalid config value '" + fileEntry.getValue() + "'");
            }
            this.registerFileEntry(fileEntry, registeredFiles, isModelType);
        }
    }

    private static boolean isEmptyOptionalPath(Map.Entry<String, ?> entry, ConfigPayloadBuilder fileEntry) {
        return entry.getValue() instanceof ConfigDefinition.OptionalPathDef && fileEntry.getValue() == null;
    }

    private void registerFileEntries(Collection<ConfigPayloadBuilder> builders, Map<Path, FileReference> registeredFiles, boolean isModelType) {
        for (ConfigPayloadBuilder builder : builders) {
            this.registerFileEntry(builder, registeredFiles, isModelType);
        }
    }

    private void registerFileEntry(ConfigPayloadBuilder builder, Map<Path, FileReference> registeredFiles, boolean isModelType) {
        Path path;
        if (isModelType) {
            ModelReference modelReference = ModelReference.valueOf((String)builder.getValue());
            if (modelReference.path().isEmpty()) {
                return;
            }
            path = Path.fromString((String)((FileReference)modelReference.path().get()).value());
        } else {
            path = Path.fromString((String)builder.getValue());
        }
        File file = path.toFile();
        if (file.isDirectory() && (file.listFiles() == null || file.listFiles().length == 0)) {
            throw new IllegalArgumentException("Directory '" + path.getRelative() + "' is empty");
        }
        FileReference reference = registeredFiles.get(path);
        if (reference == null) {
            reference = this.fileRegistry.addFile(path.getRelative());
            registeredFiles.put(path, reference);
        }
        if (reference == null) {
            throw new IllegalArgumentException("No such file or directory '" + path.getRelative() + "'");
        }
        if (isModelType) {
            ModelReference model = ModelReference.valueOf((String)builder.getValue());
            ModelReference modelWithReference = ModelReference.unresolved((Optional)model.modelId(), (Optional)model.url(), Optional.of(reference));
            builder.setValue(modelWithReference.toString());
        } else {
            builder.setValue(reference.value());
        }
    }
}

