/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.search.Tuning;
import org.w3c.dom.Element;

public class DomSearchTuningBuilder
extends VespaDomBuilder.DomConfigProducerBuilderBase<Tuning> {
    @Override
    protected Tuning doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element spec) {
        Tuning tuning = new Tuning(parent);
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("searchnode", e)) continue;
            this.handleSearchNode(e, tuning);
        }
        return tuning;
    }

    private static boolean equals(String name, Element e) {
        return name.equals(e.getNodeName());
    }

    private static String asString(Element e) {
        return e.getFirstChild().getNodeValue();
    }

    private static Long asLong(Element e) {
        return Long.parseLong(e.getFirstChild().getNodeValue());
    }

    private static Integer asInt(Element e) {
        return Integer.parseInt(e.getFirstChild().getNodeValue());
    }

    private static Double asDouble(Element e) {
        return Double.parseDouble(e.getFirstChild().getNodeValue());
    }

    private void handleSearchNode(Element spec, Tuning t) {
        t.searchNode = new Tuning.SearchNode();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("requestthreads", e)) {
                this.handleRequestThreads(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("flushstrategy", e)) {
                this.handleFlushStrategy(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("resizing", e)) {
                this.handleResizing(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("index", e)) {
                this.handleIndex(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("attribute", e)) {
                this.handleAttribute(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("summary", e)) {
                this.handleSummary(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("initialize", e)) {
                this.handleInitialize(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("feeding", e)) {
                this.handleFeeding(e, t.searchNode);
                continue;
            }
            if (DomSearchTuningBuilder.equals("removed-db", e)) {
                this.handleRemovedDB(e, t.searchNode);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("lidspace", e)) continue;
            this.handleLidSpace(e, t.searchNode);
        }
    }

    private void handleLidSpace(Element spec, Tuning.SearchNode t) {
        t.lidSpace = new Tuning.SearchNode.LidSpace();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("max-bloat-factor", e)) continue;
            t.lidSpace.bloatFactor = DomSearchTuningBuilder.asDouble(e);
        }
    }

    private void handleRequestThreads(Element spec, Tuning.SearchNode sn) {
        Tuning.SearchNode.RequestThreads rt = sn.threads = new Tuning.SearchNode.RequestThreads();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("search", e)) {
                rt.numSearchThreads = DomSearchTuningBuilder.asInt(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("persearch", e)) {
                rt.numThreadsPerSearch = DomSearchTuningBuilder.asInt(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("summary", e)) continue;
            rt.numSummaryThreads = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleRemovedDB(Element spec, Tuning.SearchNode sn) {
        sn.removedDB = new Tuning.SearchNode.RemovedDB();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("prune", e)) continue;
            Tuning.SearchNode.RemovedDB.Prune prune = sn.removedDB.prune = new Tuning.SearchNode.RemovedDB.Prune();
            for (Element e2 : XML.getChildren((Element)e)) {
                if (DomSearchTuningBuilder.equals("age", e2)) {
                    prune.age = DomSearchTuningBuilder.asDouble(e2);
                    continue;
                }
                if (!DomSearchTuningBuilder.equals("interval", e2)) continue;
                prune.interval = DomSearchTuningBuilder.asDouble(e2);
            }
        }
    }

    private void handleFlushStrategy(Element spec, Tuning.SearchNode sn) {
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("native", e)) continue;
            this.handleNativeStrategy(e, sn);
        }
    }

    private void handleNativeStrategy(Element spec, Tuning.SearchNode sn) {
        Tuning.SearchNode.FlushStrategy fs = sn.strategy = new Tuning.SearchNode.FlushStrategy();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("total", e)) {
                for (Element subElem : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("maxmemorygain", subElem)) {
                        fs.totalMaxMemoryGain = DomSearchTuningBuilder.asLong(subElem);
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("diskbloatfactor", subElem)) continue;
                    fs.totalDiskBloatFactor = DomSearchTuningBuilder.asDouble(subElem);
                }
                continue;
            }
            if (DomSearchTuningBuilder.equals("component", e)) {
                for (Element subElem : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("maxmemorygain", subElem)) {
                        fs.componentMaxMemoryGain = DomSearchTuningBuilder.asLong(subElem);
                        continue;
                    }
                    if (DomSearchTuningBuilder.equals("diskbloatfactor", subElem)) {
                        fs.componentDiskBloatFactor = DomSearchTuningBuilder.asDouble(subElem);
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("maxage", subElem)) continue;
                    fs.componentMaxage = DomSearchTuningBuilder.asDouble(subElem);
                }
                continue;
            }
            if (DomSearchTuningBuilder.equals("transactionlog", e)) {
                for (Element subElem : XML.getChildren((Element)e)) {
                    if (!DomSearchTuningBuilder.equals("maxsize", subElem)) continue;
                    fs.transactionLogMaxSize = DomSearchTuningBuilder.asLong(subElem);
                }
                continue;
            }
            if (!DomSearchTuningBuilder.equals("conservative", e)) continue;
            for (Element subElem : XML.getChildren((Element)e)) {
                if (DomSearchTuningBuilder.equals("memory-limit-factor", subElem)) {
                    fs.conservativeMemoryLimitFactor = DomSearchTuningBuilder.asDouble(subElem);
                    continue;
                }
                if (!DomSearchTuningBuilder.equals("disk-limit-factor", subElem)) continue;
                fs.conservativeDiskLimitFactor = DomSearchTuningBuilder.asDouble(subElem);
            }
        }
    }

    private void handleResizing(Element spec, Tuning.SearchNode sn) {
        sn.resizing = new Tuning.SearchNode.Resizing();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("initialdocumentcount", e)) {
                sn.resizing.initialDocumentCount = DomSearchTuningBuilder.asInt(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("amortize-count", e)) continue;
            sn.resizing.amortizeCount = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleIndex(Element spec, Tuning.SearchNode sn) {
        sn.index = new Tuning.SearchNode.Index();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("io", e)) {
                Tuning.SearchNode.Index.Io io = sn.index.io = new Tuning.SearchNode.Index.Io();
                for (Element e2 : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("write", e2)) {
                        io.write = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                        continue;
                    }
                    if (DomSearchTuningBuilder.equals("read", e2)) {
                        io.read = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("search", e2)) continue;
                    io.search = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                }
                continue;
            }
            if (!DomSearchTuningBuilder.equals("warmup", e)) continue;
            Tuning.SearchNode.Index.Warmup warmup = sn.index.warmup = new Tuning.SearchNode.Index.Warmup();
            for (Element e2 : XML.getChildren((Element)e)) {
                if (DomSearchTuningBuilder.equals("time", e2)) {
                    warmup.time = DomSearchTuningBuilder.asDouble(e2);
                    continue;
                }
                if (!DomSearchTuningBuilder.equals("unpack", e2)) continue;
                warmup.unpack = Boolean.parseBoolean(DomSearchTuningBuilder.asString(e2));
            }
        }
    }

    private void handleAttribute(Element spec, Tuning.SearchNode sn) {
        sn.attribute = new Tuning.SearchNode.Attribute();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("io", e)) continue;
            sn.attribute.io = new Tuning.SearchNode.Attribute.Io();
            for (Element e2 : XML.getChildren((Element)e)) {
                if (!DomSearchTuningBuilder.equals("write", e2)) continue;
                sn.attribute.io.write = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
            }
        }
    }

    private void handleSummary(Element spec, Tuning.SearchNode sn) {
        sn.summary = new Tuning.SearchNode.Summary();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("io", e)) {
                sn.summary.io = new Tuning.SearchNode.Summary.Io();
                for (Element e2 : XML.getChildren((Element)e)) {
                    if (DomSearchTuningBuilder.equals("write", e2)) {
                        sn.summary.io.write = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                        continue;
                    }
                    if (!DomSearchTuningBuilder.equals("read", e2)) continue;
                    sn.summary.io.read = Tuning.SearchNode.IoType.fromString(DomSearchTuningBuilder.asString(e2));
                }
                continue;
            }
            if (!DomSearchTuningBuilder.equals("store", e)) continue;
            this.handleSummaryStore(e, sn.summary);
        }
    }

    private void handleSummaryStore(Element spec, Tuning.SearchNode.Summary s) {
        s.store = new Tuning.SearchNode.Summary.Store();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("cache", e)) {
                s.store.cache = new Tuning.SearchNode.Summary.Store.Component();
                this.handleSummaryStoreComponent(e, s.store.cache);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("logstore", e)) continue;
            this.handleSummaryLogStore(e, s.store);
        }
    }

    private void handleSummaryStoreComponent(Element spec, Tuning.SearchNode.Summary.Store.Component c) {
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("maxsize", e)) {
                c.maxSize = DomSearchTuningBuilder.asLong(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("maxsize-percent", e)) {
                c.maxSizePercent = DomSearchTuningBuilder.asDouble(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("initialentries", e)) {
                c.initialEntries = DomSearchTuningBuilder.asLong(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("compression", e)) continue;
            c.compression = new Tuning.SearchNode.Summary.Store.Compression();
            this.handleSummaryStoreCompression(e, c.compression);
        }
    }

    private void handleSummaryStoreCompression(Element spec, Tuning.SearchNode.Summary.Store.Compression c) {
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("type", e)) {
                c.type = Tuning.SearchNode.Summary.Store.Compression.Type.fromString(DomSearchTuningBuilder.asString(e));
                continue;
            }
            if (!DomSearchTuningBuilder.equals("level", e)) continue;
            c.level = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleSummaryLogStore(Element spec, Tuning.SearchNode.Summary.Store s) {
        s.logStore = new Tuning.SearchNode.Summary.Store.LogStore();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("maxfilesize", e)) {
                s.logStore.maxFileSize = DomSearchTuningBuilder.asLong(e);
                continue;
            }
            if (DomSearchTuningBuilder.equals("minfilesizefactor", e)) {
                s.logStore.minFileSizeFactor = DomSearchTuningBuilder.asDouble(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("chunk", e)) continue;
            s.logStore.chunk = new Tuning.SearchNode.Summary.Store.Component(true);
            this.handleSummaryStoreComponent(e, s.logStore.chunk);
        }
    }

    private void handleInitialize(Element spec, Tuning.SearchNode sn) {
        sn.initialize = new Tuning.SearchNode.Initialize();
        for (Element e : XML.getChildren((Element)spec)) {
            if (!DomSearchTuningBuilder.equals("threads", e)) continue;
            sn.initialize.threads = DomSearchTuningBuilder.asInt(e);
        }
    }

    private void handleFeeding(Element spec, Tuning.SearchNode sn) {
        sn.feeding = new Tuning.SearchNode.Feeding();
        for (Element e : XML.getChildren((Element)spec)) {
            if (DomSearchTuningBuilder.equals("concurrency", e)) {
                sn.feeding.concurrency = DomSearchTuningBuilder.asDouble(e);
                continue;
            }
            if (!DomSearchTuningBuilder.equals("niceness", e)) continue;
            sn.feeding.niceness = DomSearchTuningBuilder.asDouble(e);
        }
    }
}

