/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.Configserver;
import com.yahoo.vespa.model.admin.Logserver;
import com.yahoo.vespa.model.admin.Slobrok;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerCluster;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainerCluster;
import com.yahoo.vespa.model.builder.xml.dom.DomAdminBuilderBase;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class DomAdminV2Builder
extends DomAdminBuilderBase {
    private static final String ATTRIBUTE_CLUSTER_CONTROLLER_STANDALONE_ZK = "standalone-zookeeper";

    public DomAdminV2Builder(ConfigModelContext.ApplicationType applicationType, boolean multitenant, List<ConfigServerSpec> configServerSpecs) {
        super(applicationType, multitenant, configServerSpecs);
    }

    @Override
    protected void doBuildAdmin(DeployState deployState, Admin admin, Element adminE) {
        List<Configserver> configservers = this.parseConfigservers(deployState, admin, adminE);
        admin.setLogserver(this.parseLogserver(deployState, admin, adminE));
        admin.addConfigservers(configservers);
        admin.addSlobroks(this.getSlobroks(deployState, admin, XML.getChild((Element)adminE, (String)"slobroks")));
        if (!admin.multitenant()) {
            admin.setClusterControllers(this.addConfiguredClusterControllers(deployState, admin, adminE), deployState);
        }
        this.addLogForwarders(new ModelElement(adminE).child("logforwarding"), admin, deployState);
        this.addLoggingSpecs(new ModelElement(adminE).child("logging"), admin);
    }

    private List<Configserver> parseConfigservers(DeployState deployState, Admin admin, Element adminE) {
        List<Configserver> configservers = this.multitenant ? this.getConfigServersFromSpec(deployState, admin) : this.getConfigServers(deployState, admin, adminE);
        if (configservers.isEmpty() && !this.multitenant) {
            configservers = this.createSingleConfigServer(deployState, admin);
        }
        if (configservers.size() % 2 == 0) {
            deployState.getDeployLogger().logApplicationPackage(Level.WARNING, "An even number (" + configservers.size() + ") of config servers have been configured. This is discouraged, see doc for configuration server ");
        }
        return configservers;
    }

    private Logserver parseLogserver(DeployState deployState, Admin admin, Element adminE) {
        Element logserverE = XML.getChild((Element)adminE, (String)"logserver");
        if (logserverE == null) {
            Element adminserverE = XML.getChild((Element)adminE, (String)"adminserver");
            logserverE = adminserverE != null ? adminserverE : adminE;
        }
        return (Logserver)new LogserverBuilder().build(deployState, admin, logserverE);
    }

    private ClusterControllerContainerCluster addConfiguredClusterControllers(DeployState deployState, TreeConfigProducer<?> parent, Element admin) {
        boolean standaloneZooKeeper;
        Element controllersElements = XML.getChild((Element)admin, (String)"cluster-controllers");
        if (controllersElements == null) {
            return null;
        }
        List controllers = XML.getChildren((Element)controllersElements, (String)"cluster-controller");
        if (controllers.isEmpty()) {
            return null;
        }
        boolean bl = standaloneZooKeeper = "true".equals(controllersElements.getAttribute(ATTRIBUTE_CLUSTER_CONTROLLER_STANDALONE_ZK)) || this.multitenant;
        if (standaloneZooKeeper) {
            parent = new ClusterControllerCluster(parent, "standalone", deployState);
        }
        ClusterControllerContainerCluster cluster = new ClusterControllerContainerCluster(parent, "cluster-controllers", "cluster-controllers", deployState);
        ArrayList<ClusterControllerContainer> containers = new ArrayList<ClusterControllerContainer>();
        for (Element controller : controllers) {
            ClusterControllerContainer clusterController = (ClusterControllerContainer)new ClusterControllerBuilder(containers.size(), standaloneZooKeeper).build(deployState, cluster, controller);
            containers.add(clusterController);
        }
        cluster.addContainers(containers);
        return cluster;
    }

    private List<Configserver> getConfigServers(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element adminE) {
        Element configserversE = XML.getChild((Element)adminE, (String)"configservers");
        if (configserversE == null) {
            Element adminserver = XML.getChild((Element)adminE, (String)"adminserver");
            if (adminserver == null) {
                return this.createSingleConfigServer(deployState, parent);
            }
            SimpleConfigProducer configServers = new SimpleConfigProducer(parent, "configservers");
            return List.of((Configserver)new ConfigserverBuilder(0, this.configServerSpecs).build(deployState, configServers, adminserver));
        }
        SimpleConfigProducer configServers = new SimpleConfigProducer(parent, "configservers");
        ArrayList<Configserver> configservers = new ArrayList<Configserver>();
        int i = 0;
        for (Element configserverE : XML.getChildren((Element)configserversE, (String)"configserver")) {
            configservers.add((Configserver)new ConfigserverBuilder(i++, this.configServerSpecs).build(deployState, configServers, configserverE));
        }
        return configservers;
    }

    private List<Configserver> createSingleConfigServer(DeployState deployState, TreeConfigProducer<?> parent) {
        SimpleConfigProducer configServers = new SimpleConfigProducer(parent, "configservers");
        Configserver configServer = new Configserver(configServers, "configserver", 19070);
        configServer.setHostResource(parent.hostSystem().getHost("default_singlenode_container"));
        configServer.initService(deployState);
        return List.of(configServer);
    }

    private List<Slobrok> getSlobroks(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element slobroksE) {
        List<Slobrok> slobroks = new ArrayList<Slobrok>();
        if (slobroksE != null) {
            slobroks = this.getExplicitSlobrokSetup(deployState, parent, slobroksE);
        }
        return slobroks;
    }

    private List<Slobrok> getExplicitSlobrokSetup(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element slobroksE) {
        ArrayList<Slobrok> slobroks = new ArrayList<Slobrok>();
        int i = 0;
        for (Element e : XML.getChildren((Element)slobroksE, (String)"slobrok")) {
            slobroks.add((Slobrok)new SlobrokBuilder(i++).build(deployState, parent, e));
        }
        return slobroks;
    }

    private static class LogserverBuilder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<Logserver> {
        @Override
        protected Logserver doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element producerSpec) {
            return new Logserver(parent);
        }
    }

    private static class ClusterControllerBuilder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<ClusterControllerContainer> {
        int i;
        boolean runStandaloneZooKeeper;

        public ClusterControllerBuilder(int i, boolean runStandaloneZooKeeper) {
            this.i = i;
            this.runStandaloneZooKeeper = runStandaloneZooKeeper;
        }

        @Override
        protected ClusterControllerContainer doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element spec) {
            return new ClusterControllerContainer(parent, this.i, this.runStandaloneZooKeeper, deployState, false);
        }
    }

    private static class ConfigserverBuilder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<Configserver> {
        private final int i;
        private final int rpcPort;

        public ConfigserverBuilder(int i, List<ConfigServerSpec> configServerSpec) {
            this.i = i;
            Objects.requireNonNull(configServerSpec);
            this.rpcPort = configServerSpec.size() > 0 ? configServerSpec.get(0).getConfigServerPort() : 19070;
        }

        @Override
        protected Configserver doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element spec) {
            Configserver configServer = new Configserver(parent, "configserver." + this.i, this.rpcPort);
            configServer.setProp("index", this.i);
            return configServer;
        }
    }

    private static class SlobrokBuilder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<Slobrok> {
        int i;

        public SlobrokBuilder(int i) {
            this.i = i;
        }

        @Override
        protected Slobrok doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> parent, Element spec) {
            return new Slobrok(parent, this.i, deployState.featureFlags());
        }
    }
}

