/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.storagecluster;

import ai.vespa.metrics.StorageMetrics;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.vespa.config.content.PersistenceConfig;
import com.yahoo.vespa.config.content.StorFilestorConfig;
import com.yahoo.vespa.config.content.core.StorBucketmoverConfig;
import com.yahoo.vespa.config.content.core.StorIntegritycheckerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.content.core.StorVisitorConfig;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import com.yahoo.vespa.model.content.storagecluster.FileStorProducer;
import com.yahoo.vespa.model.content.storagecluster.IntegrityCheckerProducer;
import com.yahoo.vespa.model.content.storagecluster.PersistenceProducer;
import com.yahoo.vespa.model.content.storagecluster.StorServerProducer;
import com.yahoo.vespa.model.content.storagecluster.StorVisitorProducer;
import org.w3c.dom.Element;

public class StorageCluster
extends TreeConfigProducer<StorageNode>
implements StorServerConfig.Producer,
StorBucketmoverConfig.Producer,
StorIntegritycheckerConfig.Producer,
StorFilestorConfig.Producer,
StorVisitorConfig.Producer,
PersistenceConfig.Producer,
MetricsmanagerConfig.Producer {
    private final String clusterName;
    private final FileStorProducer fileStorProducer;
    private final IntegrityCheckerProducer integrityCheckerProducer;
    private final StorServerProducer storServerProducer;
    private final StorVisitorProducer storVisitorProducer;
    private final PersistenceProducer persistenceProducer;

    StorageCluster(TreeConfigProducer<?> parent, String clusterName, FileStorProducer fileStorProducer, IntegrityCheckerProducer integrityCheckerProducer, StorServerProducer storServerProducer, StorVisitorProducer storVisitorProducer, PersistenceProducer persistenceProducer) {
        super(parent, "storage");
        this.clusterName = clusterName;
        this.fileStorProducer = fileStorProducer;
        this.integrityCheckerProducer = integrityCheckerProducer;
        this.storServerProducer = storServerProducer;
        this.storVisitorProducer = storVisitorProducer;
        this.persistenceProducer = persistenceProducer;
    }

    public void getConfig(StorBucketmoverConfig.Builder builder) {
    }

    public void getConfig(MetricsmanagerConfig.Builder builder) {
        ContentCluster.getMetricBuilder("fleetcontroller", builder).addedmetrics(StorageMetrics.VDS_DATASTORED_ALLDISKS_DOCS.baseName()).addedmetrics(StorageMetrics.VDS_DATASTORED_ALLDISKS_BYTES.baseName()).addedmetrics(StorageMetrics.VDS_DATASTORED_ALLDISKS_BUCKETS.baseName()).addedmetrics(StorageMetrics.VDS_DATASTORED_BUCKET_SPACE_BUCKETS_TOTAL.baseName());
        ContentCluster.getMetricBuilder("log", builder).addedmetrics("vds.filestor.allthreads.put").addedmetrics("vds.filestor.allthreads.get").addedmetrics("vds.filestor.allthreads.remove").addedmetrics("vds.filestor.allthreads.update").addedmetrics(StorageMetrics.VDS_DATASTORED_ALLDISKS_DOCS.baseName()).addedmetrics(StorageMetrics.VDS_DATASTORED_ALLDISKS_BYTES.baseName()).addedmetrics(StorageMetrics.VDS_FILESTOR_QUEUESIZE.baseName()).addedmetrics(StorageMetrics.VDS_FILESTOR_AVERAGEQUEUEWAIT.baseName()).addedmetrics(StorageMetrics.VDS_VISITOR_CV_QUEUEWAITTIME.baseName()).addedmetrics(StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEQUEUEWAIT.baseName()).addedmetrics(StorageMetrics.VDS_VISITOR_ALLTHREADS_AVERAGEVISITORLIFETIME.baseName()).addedmetrics(StorageMetrics.VDS_VISITOR_ALLTHREADS_CREATED.baseName());
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void getConfig(StorIntegritycheckerConfig.Builder builder) {
        this.integrityCheckerProducer.getConfig(builder);
    }

    public void getConfig(StorServerConfig.Builder builder) {
        this.storServerProducer.getConfig(builder);
    }

    public void getConfig(StorVisitorConfig.Builder builder) {
        this.storVisitorProducer.getConfig(builder);
    }

    public void getConfig(PersistenceConfig.Builder builder) {
        this.persistenceProducer.getConfig(builder);
    }

    public void getConfig(StorFilestorConfig.Builder builder) {
        this.fileStorProducer.getConfig(builder);
        this.storVisitorProducer.getConfig(builder);
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<StorageCluster> {
        @Override
        protected StorageCluster doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element producerSpec) {
            ModelElement clusterElem = new ModelElement(producerSpec);
            ContentCluster cluster = (ContentCluster)ancestor;
            return new StorageCluster(ancestor, ContentCluster.getClusterId(clusterElem), new FileStorProducer.Builder().build(deployState.getProperties(), cluster, clusterElem), new IntegrityCheckerProducer.Builder().build(cluster, clusterElem), new StorServerProducer.Builder().build(clusterElem), new StorVisitorProducer.Builder().build(clusterElem), new PersistenceProducer.Builder().build(clusterElem));
        }
    }
}

