/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.security.tls.TlsContext;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.ssl.CloudSslProvider;
import com.yahoo.vespa.model.container.http.ssl.DefaultSslProvider;
import com.yahoo.vespa.model.container.http.ssl.SslProvider;
import java.time.Duration;
import java.util.Collection;
import java.util.List;

public class HostedSslConnectorFactory
extends ConnectorFactory {
    private static final List<String> INSECURE_WHITELISTED_PATHS = List.of("/status.html");
    private static final String DEFAULT_HOSTED_TRUSTSTORE = "/opt/yahoo/share/ssl/certs/athenz_certificate_bundle.pem";
    private final boolean enforceClientAuth;
    private final boolean enforceHandshakeClientAuth;
    private final Collection<String> tlsCiphersOverride;
    private final boolean enableProxyProtocolMixedMode;
    private final Duration endpointConnectionTtl;

    public static HostedSslConnectorFactory withProvidedCertificate(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, boolean enforceHandshakeClientAuth, Collection<String> tlsCiphersOverride, boolean enableProxyProtocolMixedMode, int port, Duration endpointConnectionTtl, boolean enableTokenSupport) {
        CloudSslProvider sslProvider = HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, DEFAULT_HOSTED_TRUSTSTORE, null, enforceHandshakeClientAuth, enableTokenSupport);
        return new HostedSslConnectorFactory(sslProvider, false, enforceHandshakeClientAuth, tlsCiphersOverride, enableProxyProtocolMixedMode, port, endpointConnectionTtl);
    }

    public static HostedSslConnectorFactory withProvidedCertificateAndTruststore(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificates, Collection<String> tlsCiphersOverride, boolean enableProxyProtocolMixedMode, int port, Duration endpointConnectionTtl, boolean enableTokenSupport) {
        CloudSslProvider sslProvider = HostedSslConnectorFactory.createConfiguredDirectSslProvider(serverName, endpointCertificateSecrets, null, tlsCaCertificates, false, enableTokenSupport);
        return new HostedSslConnectorFactory(sslProvider, true, false, tlsCiphersOverride, enableProxyProtocolMixedMode, port, endpointConnectionTtl);
    }

    public static HostedSslConnectorFactory withDefaultCertificateAndTruststore(String serverName, Collection<String> tlsCiphersOverride, boolean enableProxyProtocolMixedMode, int port, Duration endpointConnectionTtl) {
        return new HostedSslConnectorFactory(new DefaultSslProvider(serverName), true, false, tlsCiphersOverride, enableProxyProtocolMixedMode, port, endpointConnectionTtl);
    }

    private HostedSslConnectorFactory(SslProvider sslProvider, boolean enforceClientAuth, boolean enforceHandshakeClientAuth, Collection<String> tlsCiphersOverride, boolean enableProxyProtocolMixedMode, int port, Duration endpointConnectionTtl) {
        super(new ConnectorFactory.Builder("tls" + port, port).sslProvider(sslProvider));
        this.enforceClientAuth = enforceClientAuth;
        this.enforceHandshakeClientAuth = enforceHandshakeClientAuth;
        this.tlsCiphersOverride = tlsCiphersOverride;
        this.enableProxyProtocolMixedMode = enableProxyProtocolMixedMode;
        this.endpointConnectionTtl = endpointConnectionTtl;
    }

    private static CloudSslProvider createConfiguredDirectSslProvider(String serverName, EndpointCertificateSecrets endpointCertificateSecrets, String tlsCaCertificatesPath, String tlsCaCertificates, boolean enforceHandshakeClientAuth, boolean enableTokenSupport) {
        ConnectorConfig.Ssl.ClientAuth.Enum clientAuthentication = enforceHandshakeClientAuth ? ConnectorConfig.Ssl.ClientAuth.Enum.NEED_AUTH : ConnectorConfig.Ssl.ClientAuth.Enum.WANT_AUTH;
        return new CloudSslProvider(serverName, endpointCertificateSecrets.key(), endpointCertificateSecrets.certificate(), tlsCaCertificatesPath, tlsCaCertificates, clientAuthentication, enableTokenSupport);
    }

    @Override
    public void getConfig(ConnectorConfig.Builder connectorBuilder) {
        super.getConfig(connectorBuilder);
        if (!this.enforceHandshakeClientAuth) {
            connectorBuilder.tlsClientAuthEnforcer(new ConnectorConfig.TlsClientAuthEnforcer.Builder().pathWhitelist(INSECURE_WHITELISTED_PATHS).enable(this.enforceClientAuth));
        }
        connectorBuilder.ssl.enabledProtocols(List.of("TLSv1.2"));
        if (!this.tlsCiphersOverride.isEmpty()) {
            connectorBuilder.ssl.enabledCipherSuites(this.tlsCiphersOverride.stream().sorted().toList());
        } else {
            connectorBuilder.ssl.enabledCipherSuites(TlsContext.ALLOWED_CIPHER_SUITES.stream().sorted().toList());
        }
        connectorBuilder.proxyProtocol(new ConnectorConfig.ProxyProtocol.Builder().enabled(true).mixedMode(this.enableProxyProtocolMixedMode)).idleTimeout((double)Duration.ofSeconds(30L).toSeconds()).maxConnectionLife(this.endpointConnectionTtl != null ? (double)this.endpointConnectionTtl.toSeconds() : 0.0);
    }
}

