/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.collections.Tuple2;
import com.yahoo.config.FileReference;
import com.yahoo.config.ModelReference;
import com.yahoo.config.UrlReference;
import com.yahoo.text.XML;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import com.yahoo.vespa.config.ConfigPayloadBuilder;
import com.yahoo.vespa.config.util.ConfigUtils;
import com.yahoo.yolean.Exceptions;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomConfigPayloadBuilder {
    private static final Pattern namePattern = ConfigDefinition.namePattern;
    private static final Pattern namespacePattern = ConfigDefinition.namespacePattern;
    private final ConfigDefinition configDefinition;

    public DomConfigPayloadBuilder(ConfigDefinition configDefinition) {
        this.configDefinition = configDefinition;
    }

    public ConfigPayloadBuilder build(Element configE) {
        DomConfigPayloadBuilder.parseConfigName(configE);
        ConfigPayloadBuilder payloadBuilder = new ConfigPayloadBuilder(this.configDefinition);
        for (Element child : XML.getChildren((Element)configE)) {
            this.parseElement(child, payloadBuilder, null);
        }
        return payloadBuilder;
    }

    public static ConfigDefinitionKey parseConfigName(Element configE) {
        if (!configE.getNodeName().equals("config")) {
            throw new IllegalArgumentException("The root element must be 'config', but was '" + configE.getNodeName() + "'");
        }
        if (!configE.hasAttribute("name")) {
            throw new IllegalArgumentException("The 'config' element must have a 'name' attribute that matches the name of the config definition");
        }
        String elementString = configE.getAttribute("name");
        if (!elementString.contains(".")) {
            throw new IllegalArgumentException("The config name '" + elementString + "' contains illegal characters. Only names with the pattern " + namespacePattern.pattern() + "." + namePattern.pattern() + " are legal.");
        }
        Tuple2 t = ConfigUtils.getNameAndNamespaceFromString((String)elementString);
        String xmlName = (String)t.first;
        String xmlNamespace = (String)t.second;
        if (!DomConfigPayloadBuilder.validName(xmlName)) {
            throw new IllegalArgumentException("The config name '" + xmlName + "' contains illegal characters. Only names with the pattern " + namePattern.toString() + " are legal.");
        }
        if (!DomConfigPayloadBuilder.validNamespace(xmlNamespace)) {
            throw new IllegalArgumentException("The config namespace '" + xmlNamespace + "' contains illegal characters. Only namespaces with the pattern " + namespacePattern.toString() + " are legal.");
        }
        return new ConfigDefinitionKey(xmlName, xmlNamespace);
    }

    private static boolean validName(String name) {
        if (name == null) {
            return false;
        }
        return namePattern.matcher(name).matches();
    }

    private static boolean validNamespace(String namespace) {
        if (namespace == null) {
            return false;
        }
        return namespacePattern.matcher(namespace).matches();
    }

    private String extractName(Element element) {
        String initial = element.getNodeName();
        if (initial.indexOf(45) < 0) {
            return initial;
        }
        StringBuilder buf = new StringBuilder();
        boolean upcase = false;
        for (char ch : initial.toCharArray()) {
            if (ch == '-') {
                upcase = true;
                continue;
            }
            if (upcase && ch >= 'a' && ch <= 'z') {
                buf.append((char)(65 + ch - 97));
                upcase = false;
                continue;
            }
            buf.append(ch);
            upcase = false;
        }
        return buf.toString();
    }

    private void parseLeaf(Element element, ConfigPayloadBuilder payloadBuilder, String parentName) {
        String name = this.extractName(element);
        String value = XML.getValue((Element)element);
        if (value == null) {
            throw new IllegalArgumentException("Element '" + name + "' must have either children or a value");
        }
        if ("item".equals(name)) {
            if (parentName == null) {
                throw new IllegalArgumentException("<item> is a reserved keyword for array and map elements");
            }
            if (element.hasAttribute("key")) {
                payloadBuilder.getMap(parentName).put(element.getAttribute("key"), value);
            } else {
                payloadBuilder.getArray(parentName).append(value);
            }
        } else if (element.hasAttribute("model-id") || element.hasAttribute("url") || element.hasAttribute("path")) {
            ModelReference model = ModelReference.unresolved(this.modelElement("model-id", element), this.modelElement("url", element).map(UrlReference::new), this.modelElement("path", element).map(FileReference::new));
            payloadBuilder.setField(name, model.toString());
        } else {
            payloadBuilder.setField(name, value);
        }
    }

    private Optional<String> modelElement(String attributeName, Element element) {
        Optional value = XML.attribute((String)attributeName, (Element)element);
        if (value.isPresent() && ((String)value.get()).contains(" ")) {
            throw new IllegalArgumentException("The value of " + attributeName + " on " + element.getTagName() + "cannot contain space");
        }
        return value;
    }

    private void parseComplex(Element element, List<Element> children, ConfigPayloadBuilder payloadBuilder, String parentName) {
        String name = this.extractName(element);
        if ("item".equals(name)) {
            if (element.hasAttribute("key")) {
                ConfigPayloadBuilder childPayloadBuilder = payloadBuilder.getMap(parentName).get(element.getAttribute("key"));
                for (Element element2 : children) {
                    this.parseElement(element2, childPayloadBuilder, parentName);
                }
            } else {
                ConfigPayloadBuilder.Array array = payloadBuilder.getArray(parentName);
                ConfigPayloadBuilder childPayloadBuilder = array.append();
                for (Element child : children) {
                    this.parseElement(child, childPayloadBuilder, parentName);
                }
            }
        } else {
            int numMatching = 0;
            for (Element element3 : children) {
                numMatching += "item".equals(element3.getTagName()) ? 1 : 0;
            }
            if (numMatching == 0) {
                ConfigPayloadBuilder p = payloadBuilder.getObject(name);
                for (Element child : children) {
                    this.parseElement(child, p, name);
                }
            } else if (numMatching == children.size()) {
                for (Element element4 : children) {
                    this.parseElement(element4, payloadBuilder, name);
                }
            } else {
                throw new IllegalArgumentException("<item> is a reserved keyword for array and map elements");
            }
        }
    }

    private void parseElement(Element currElem, ConfigPayloadBuilder payloadBuilder, String parentName) {
        List children = XML.getChildren((Element)currElem);
        try {
            if (children.isEmpty()) {
                this.parseLeaf(currElem, payloadBuilder, parentName);
            } else {
                this.parseComplex(currElem, children, payloadBuilder, parentName);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error parsing element at " + XML.getNodePath((Node)currElem, (String)" > ") + ": " + Exceptions.toMessageString((Throwable)exception));
        }
    }
}

