/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring.builder.xml;

import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.admin.monitoring.DefaultVespaMetrics;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.SystemMetrics;
import com.yahoo.vespa.model.admin.monitoring.builder.Metrics;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class MetricsBuilder {
    private static final String ID_ATTRIBUTE = "id";
    private static final String DISPLAY_NAME_ATTRIBUTE = "display-name";
    private final ConfigModelContext.ApplicationType applicationType;
    private final Map<String, MetricSet> availableMetricSets;

    public MetricsBuilder(ConfigModelContext.ApplicationType applicationType, Map<String, MetricSet> availableMetricSets) {
        this.applicationType = applicationType;
        this.availableMetricSets = availableMetricSets;
    }

    public Metrics buildMetrics(Element metricsElement) {
        Metrics metrics = new Metrics();
        for (Element consumerElement : XML.getChildren((Element)metricsElement, (String)"consumer")) {
            String consumerId = consumerElement.getAttribute(ID_ATTRIBUTE);
            this.throwIfIllegalConsumerId(metrics, consumerId);
            MetricSet metricSet = this.buildMetricSet(consumerId, consumerElement);
            MetricsConsumer consumer = new MetricsConsumer(consumerId, metricSet);
            metrics.addConsumer(consumer);
        }
        return metrics;
    }

    private static Metric metricFromElement(Element elem) {
        String m_id = elem.getAttribute(ID_ATTRIBUTE);
        String m_dn = elem.getAttribute(DISPLAY_NAME_ATTRIBUTE);
        if (m_dn == null || "".equals(m_dn)) {
            return new Metric(m_id);
        }
        return new Metric(m_id, m_dn);
    }

    private MetricSet buildMetricSet(String consumerId, Element consumerElement) {
        List metrics = XML.getChildren((Element)consumerElement, (String)"metric").stream().map(MetricsBuilder::metricFromElement).collect(Collectors.toCollection(LinkedList::new));
        List metricSets = XML.getChildren((Element)consumerElement, (String)"metric-set").stream().map(metricSetElement -> this.getMetricSetOrThrow(metricSetElement.getAttribute(ID_ATTRIBUTE))).collect(Collectors.toCollection(LinkedList::new));
        metricSets.add(DefaultVespaMetrics.defaultVespaMetricSet);
        metricSets.add(SystemMetrics.systemMetricSet);
        return new MetricSet(MetricsBuilder.metricSetId(consumerId), metrics, metricSets);
    }

    private static String metricSetId(String consumerName) {
        return "user-metrics-" + consumerName;
    }

    private MetricSet getMetricSetOrThrow(String id) {
        if (!this.availableMetricSets.containsKey(id)) {
            throw new IllegalArgumentException("No such metric-set: " + id);
        }
        return this.availableMetricSets.get(id);
    }

    private void throwIfIllegalConsumerId(Metrics metrics, String consumerId) {
        if (consumerId.equalsIgnoreCase(MetricsConsumer.vespa.id()) && this.applicationType != ConfigModelContext.ApplicationType.HOSTED_INFRASTRUCTURE) {
            throw new IllegalArgumentException("'Vespa' is not allowed as metrics consumer id (case is ignored.)");
        }
        if (consumerId.equalsIgnoreCase(MetricsConsumer.defaultConsumer.id())) {
            throw new IllegalArgumentException("'" + MetricsConsumer.defaultConsumer.id() + "' is not allowed as metrics consumer id (case is ignored.)");
        }
        if (consumerId.equalsIgnoreCase(MetricsConsumer.autoscaling.id())) {
            throw new IllegalArgumentException("'" + MetricsConsumer.autoscaling.id() + " is not allowed as metrics consumer id (case is ignored.)");
        }
        if (consumerId.equalsIgnoreCase(MetricsConsumer.vespaCloud.id())) {
            throw new IllegalArgumentException("'" + MetricsConsumer.vespaCloud.id() + " is not allowed as metrics consumer id (case is ignored.)");
        }
        if (metrics.hasConsumerIgnoreCase(consumerId)) {
            throw new IllegalArgumentException("'" + consumerId + "' is used as id for two metrics consumers (case is ignored.)");
        }
    }
}

