/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.document;

import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.GeoPos;
import com.yahoo.schema.document.ImmutableSDField;

public class ComplexAttributeFieldUtils {
    public static boolean isSupportedComplexField(ImmutableSDField field) {
        return ComplexAttributeFieldUtils.isSupportedComplexField(field, false);
    }

    public static boolean isSupportedComplexField(ImmutableSDField field, boolean stricterValidation) {
        return ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field, stricterValidation) || ComplexAttributeFieldUtils.isMapOfSimpleStruct(field, stricterValidation) || ComplexAttributeFieldUtils.isMapOfPrimitiveType(field);
    }

    public static boolean isArrayOfSimpleStruct(ImmutableSDField field, boolean stricterValidation) {
        if (field.getDataType() instanceof ArrayDataType) {
            ArrayDataType arrayType = (ArrayDataType)field.getDataType();
            return ComplexAttributeFieldUtils.isStructWithPrimitiveStructFieldAttributes(arrayType.getNestedType(), field, stricterValidation);
        }
        return false;
    }

    public static boolean isMapOfSimpleStruct(ImmutableSDField field, boolean stricterValidation) {
        if (field.getDataType() instanceof MapDataType) {
            MapDataType mapType = (MapDataType)field.getDataType();
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isStructWithPrimitiveStructFieldAttributes(mapType.getValueType(), field.getStructField("value"), stricterValidation);
        }
        return false;
    }

    public static boolean isMapOfPrimitiveType(ImmutableSDField field) {
        if (field.getDataType() instanceof MapDataType) {
            MapDataType mapType = (MapDataType)field.getDataType();
            return ComplexAttributeFieldUtils.isPrimitiveType(mapType.getKeyType()) && ComplexAttributeFieldUtils.isPrimitiveType(mapType.getValueType());
        }
        return false;
    }

    private static boolean isStructWithPrimitiveStructFieldAttributes(DataType type, ImmutableSDField field, boolean stricterValidation) {
        if (type instanceof StructDataType && !GeoPos.isPos(type)) {
            for (ImmutableSDField immutableSDField : field.getStructFields()) {
                Attribute attribute = immutableSDField.getAttributes().get(immutableSDField.getName());
                if (attribute != null ? !ComplexAttributeFieldUtils.isPrimitiveType(attribute) : immutableSDField.wasConfiguredToDoAttributing() && !ComplexAttributeFieldUtils.isPrimitiveType(immutableSDField.getDataType())) {
                    return false;
                }
                if (!stricterValidation || immutableSDField.isImportedField() || !ComplexAttributeFieldUtils.hasStructFieldAttributes(immutableSDField)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean hasStructFieldAttributes(ImmutableSDField field) {
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            Attribute attribute = immutableSDField.getAttributes().get(immutableSDField.getName());
            if (attribute != null) {
                return true;
            }
            if (!ComplexAttributeFieldUtils.hasStructFieldAttributes(immutableSDField)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveType(Attribute attribute) {
        return attribute.getCollectionType().equals((Object)Attribute.CollectionType.SINGLE) && ComplexAttributeFieldUtils.isPrimitiveType(attribute.getDataType());
    }

    public static boolean isPrimitiveType(DataType dataType) {
        return dataType.equals((Object)DataType.BYTE) || dataType.equals((Object)DataType.INT) || dataType.equals((Object)DataType.LONG) || dataType.equals((Object)DataType.FLOAT) || dataType.equals((Object)DataType.DOUBLE) || dataType.equals((Object)DataType.STRING);
    }

    public static boolean isComplexFieldWithOnlyStructFieldAttributes(ImmutableSDField field) {
        if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field, false)) {
            return ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field);
        }
        if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(field, false)) {
            return field.getStructField("key").hasSingleAttribute() && ComplexAttributeFieldUtils.hasOnlyStructFieldAttributes(field.getStructField("value"));
        }
        if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(field)) {
            return field.getStructField("key").hasSingleAttribute() && field.getStructField("value").hasSingleAttribute();
        }
        return false;
    }

    private static boolean hasOnlyStructFieldAttributes(ImmutableSDField field) {
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            if (immutableSDField.hasSingleAttribute()) continue;
            return false;
        }
        return true;
    }
}

