/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.GeoPos;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.ImportedComplexField;
import com.yahoo.schema.document.ImportedField;
import com.yahoo.vespa.config.search.ImportedFieldsConfig;
import java.util.Optional;

public class ImportedFields
extends Derived
implements ImportedFieldsConfig.Producer {
    private Optional<com.yahoo.schema.document.ImportedFields> importedFields = Optional.empty();

    public ImportedFields(Schema schema) {
        this.derive(schema);
    }

    @Override
    protected void derive(Schema schema) {
        this.importedFields = schema.importedFields();
    }

    @Override
    protected String getDerivedName() {
        return "imported-fields";
    }

    public void getConfig(ImportedFieldsConfig.Builder builder) {
        if (this.importedFields.isPresent()) {
            this.importedFields.get().fields().forEach((name, field) -> ImportedFields.considerField(builder, field));
        }
    }

    private static boolean isNestedFieldName(String fieldName) {
        return fieldName.indexOf(46) != -1;
    }

    private static void considerField(ImportedFieldsConfig.Builder builder, ImportedField field) {
        if (field instanceof ImportedComplexField) {
            ImportedFields.considerComplexField(builder, (ImportedComplexField)field);
        } else {
            ImportedFields.considerSimpleField(builder, field);
        }
    }

    private static void considerComplexField(ImportedFieldsConfig.Builder builder, ImportedComplexField field) {
        ImmutableSDField targetField = field.targetField();
        if (!GeoPos.isAnyPos(targetField)) {
            if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(targetField, false)) {
                ImportedFields.considerNestedFields(builder, field);
            } else if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(targetField, false)) {
                ImportedFields.considerSimpleField(builder, field.getNestedField("key"));
                ImportedFields.considerNestedFields(builder, field.getNestedField("value"));
            } else if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(targetField)) {
                ImportedFields.considerSimpleField(builder, field.getNestedField("key"));
                ImportedFields.considerSimpleField(builder, field.getNestedField("value"));
            }
        }
    }

    private static void considerNestedFields(ImportedFieldsConfig.Builder builder, ImportedField field) {
        if (field instanceof ImportedComplexField) {
            ImportedComplexField complexField = (ImportedComplexField)field;
            complexField.getNestedFields().forEach(nestedField -> ImportedFields.considerSimpleField(builder, nestedField));
        }
    }

    private static void considerSimpleField(ImportedFieldsConfig.Builder builder, ImportedField field) {
        ImmutableSDField targetField = field.targetField();
        String targetFieldName = targetField.getName();
        if (!ImportedFields.isNestedFieldName(targetFieldName)) {
            if (targetField.doesAttributing()) {
                builder.attribute.add(ImportedFields.createAttributeBuilder(field));
            }
        } else {
            Attribute attribute = targetField.getAttribute();
            if (attribute != null) {
                builder.attribute.add(ImportedFields.createAttributeBuilder(field));
            }
        }
    }

    private static ImportedFieldsConfig.Attribute.Builder createAttributeBuilder(ImportedField field) {
        ImportedFieldsConfig.Attribute.Builder result = new ImportedFieldsConfig.Attribute.Builder();
        result.name(field.fieldName());
        result.referencefield(field.reference().referenceField().getName());
        result.targetfield(field.targetField().getName());
        return result;
    }
}

