/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.Derived;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.ComplexAttributeFieldUtils;
import com.yahoo.schema.document.Dictionary;
import com.yahoo.schema.document.GeoPos;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.Ranking;
import com.yahoo.schema.document.Sorting;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.indexinglanguage.expressions.ToPositionExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttributeFields
extends Derived
implements AttributesConfig.Producer {
    private final Map<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
    private final Map<String, Attribute> importedAttributes = new LinkedHashMap<String, Attribute>();
    private boolean hasPosition = false;
    public static final AttributeFields empty = new AttributeFields(null);

    public AttributeFields(Schema schema) {
        if (schema != null) {
            this.derive(schema);
        }
    }

    @Override
    protected void derive(ImmutableSDField field, Schema schema) {
        if (AttributeFields.unsupportedFieldType(field)) {
            return;
        }
        if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(field, false)) {
            this.deriveArrayOfSimpleStruct(field);
        } else if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(field, false)) {
            this.deriveMapOfSimpleStruct(field);
        } else if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(field)) {
            this.deriveMapOfPrimitiveType(field);
        } else {
            this.deriveAttributes(field);
        }
    }

    private static boolean unsupportedFieldType(ImmutableSDField field) {
        return field.usesStructOrMap() && !ComplexAttributeFieldUtils.isSupportedComplexField(field) && !GeoPos.isAnyPos(field);
    }

    public Attribute getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public boolean containsAttribute(String attributeName) {
        return this.getAttribute(attributeName) != null;
    }

    private void deriveAttributes(ImmutableSDField field) {
        if (field.isImportedField()) {
            this.deriveImportedAttributes(field);
            return;
        }
        for (Attribute fieldAttribute : field.getAttributes().values()) {
            this.deriveAttribute(field, fieldAttribute);
        }
        if (field.containsExpression(ToPositionExpression.class)) {
            if (this.hasPosition) {
                throw new IllegalArgumentException("Can not specify more than one set of position attributes per field: " + field.getName());
            }
            this.hasPosition = true;
        }
    }

    private void applyRanking(ImmutableSDField field, Attribute attribute) {
        Ranking ranking = field.getRanking();
        if (ranking != null && ranking.isFilter()) {
            attribute.setEnableOnlyBitVector(true);
        }
    }

    private void deriveAttribute(ImmutableSDField field, Attribute fieldAttribute) {
        Attribute attribute = this.getAttribute(fieldAttribute.getName());
        if (attribute == null) {
            this.attributes.put(fieldAttribute.getName(), fieldAttribute);
            attribute = this.getAttribute(fieldAttribute.getName());
        }
        this.applyRanking(field, attribute);
    }

    private void deriveImportedAttributes(ImmutableSDField field) {
        for (Attribute attribute : field.getAttributes().values()) {
            if (this.importedAttributes.containsKey(field.getName())) continue;
            this.importedAttributes.put(field.getName(), attribute);
        }
    }

    private void deriveArrayOfSimpleStruct(ImmutableSDField field) {
        for (ImmutableSDField immutableSDField : field.getStructFields()) {
            this.deriveAttributeAsArrayType(immutableSDField);
        }
    }

    private void deriveAttributeAsArrayType(ImmutableSDField field) {
        if (field.isImportedField()) {
            this.deriveImportedAttributes(field);
            return;
        }
        Attribute attribute = field.getAttributes().get(field.getName());
        if (attribute != null) {
            this.applyRanking(field, attribute);
            this.attributes.put(attribute.getName(), attribute.convertToArray());
        }
    }

    private void deriveMapOfSimpleStruct(ImmutableSDField field) {
        this.deriveAttributeAsArrayType(field.getStructField("key"));
        this.deriveMapValueField(field.getStructField("value"));
    }

    private void deriveMapValueField(ImmutableSDField valueField) {
        for (ImmutableSDField immutableSDField : valueField.getStructFields()) {
            this.deriveAttributeAsArrayType(immutableSDField);
        }
    }

    private void deriveMapOfPrimitiveType(ImmutableSDField field) {
        this.deriveAttributeAsArrayType(field.getStructField("key"));
        this.deriveAttributeAsArrayType(field.getStructField("value"));
    }

    public Iterator<Attribute> attributeIterator() {
        return this.attributes().iterator();
    }

    public Collection<Attribute> attributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public Collection<Attribute> structFieldAttributes(String baseFieldName) {
        String structPrefix = baseFieldName + ".";
        return this.attributes().stream().filter(attribute -> attribute.getName().startsWith(structPrefix)).toList();
    }

    public String toString() {
        return "attributes " + this.getName();
    }

    @Override
    protected String getDerivedName() {
        return "attributes";
    }

    public void getConfig(AttributesConfig.Builder builder) {
        this.getConfig(builder, FieldSet.ALL, 77777L);
    }

    private boolean isAttributeInFieldSet(Attribute attribute, FieldSet fs) {
        return fs == FieldSet.ALL || fs == FieldSet.FAST_ACCESS && attribute.isFastAccess();
    }

    private AttributesConfig.Attribute.Builder getConfig(String attrName, Attribute attribute, boolean imported) {
        Dictionary dictionary;
        AttributesConfig.Attribute.Builder aaB = new AttributesConfig.Attribute.Builder().name(attrName).datatype(AttributesConfig.Attribute.Datatype.Enum.valueOf((String)attribute.getType().getExportAttributeTypeName())).collectiontype(AttributesConfig.Attribute.Collectiontype.Enum.valueOf((String)attribute.getCollectionType().getName()));
        if (attribute.isRemoveIfZero()) {
            aaB.removeifzero(true);
        }
        if (attribute.isCreateIfNonExistent()) {
            aaB.createifnonexistent(true);
        }
        aaB.enableonlybitvector(attribute.isEnabledOnlyBitVector());
        if (attribute.isFastSearch() || attribute.isFastRank()) {
            aaB.fastsearch(true);
        }
        if (attribute.isFastAccess()) {
            aaB.fastaccess(true);
        }
        if (attribute.isMutable()) {
            aaB.ismutable(true);
        }
        if (attribute.isPaged()) {
            aaB.paged(true);
        }
        if (attribute.getSorting().isDescending()) {
            aaB.sortascending(false);
        }
        if (attribute.getSorting().getFunction() != Sorting.Function.UCA) {
            aaB.sortfunction(AttributesConfig.Attribute.Sortfunction.Enum.valueOf((String)attribute.getSorting().getFunction().toString()));
        }
        if (attribute.getSorting().getStrength() != Sorting.Strength.PRIMARY) {
            aaB.sortstrength(AttributesConfig.Attribute.Sortstrength.Enum.valueOf((String)attribute.getSorting().getStrength().toString()));
        }
        if (!attribute.getSorting().getLocale().isEmpty()) {
            aaB.sortlocale(attribute.getSorting().getLocale());
        }
        aaB.arity(attribute.arity());
        aaB.lowerbound(attribute.lowerBound());
        aaB.upperbound(attribute.upperBound());
        aaB.densepostinglistthreshold(attribute.densePostingListThreshold());
        if (attribute.tensorType().isPresent()) {
            aaB.tensortype(attribute.tensorType().get().toString());
        }
        aaB.imported(imported);
        Attribute.DistanceMetric dma = attribute.distanceMetric();
        aaB.distancemetric(AttributesConfig.Attribute.Distancemetric.Enum.valueOf((String)dma.toString()));
        if (attribute.hnswIndexParams().isPresent()) {
            AttributesConfig.Attribute.Index.Builder ib = new AttributesConfig.Attribute.Index.Builder();
            HnswIndexParams params = attribute.hnswIndexParams().get();
            ib.hnsw.enabled(true);
            ib.hnsw.maxlinkspernode(params.maxLinksPerNode());
            ib.hnsw.neighborstoexploreatinsert(params.neighborsToExploreAtInsert());
            ib.hnsw.multithreadedindexing(params.multiThreadedIndexing());
            aaB.index(ib);
        }
        if ((dictionary = attribute.getDictionary()) != null) {
            aaB.dictionary.type(AttributeFields.convert(dictionary.getType()));
            aaB.dictionary.match(AttributeFields.convert(dictionary.getMatch()));
        }
        aaB.match(AttributeFields.convertMatch(attribute.getCase()));
        return aaB;
    }

    private static AttributesConfig.Attribute.Dictionary.Type.Enum convert(Dictionary.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Dictionary.Type.BTREE -> AttributesConfig.Attribute.Dictionary.Type.BTREE;
            case Dictionary.Type.HASH -> AttributesConfig.Attribute.Dictionary.Type.HASH;
            case Dictionary.Type.BTREE_AND_HASH -> AttributesConfig.Attribute.Dictionary.Type.BTREE_AND_HASH;
        };
    }

    private static AttributesConfig.Attribute.Dictionary.Match.Enum convert(Case type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Case.CASED -> AttributesConfig.Attribute.Dictionary.Match.CASED;
            case Case.UNCASED -> AttributesConfig.Attribute.Dictionary.Match.UNCASED;
        };
    }

    private static AttributesConfig.Attribute.Match.Enum convertMatch(Case type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Case.CASED -> AttributesConfig.Attribute.Match.CASED;
            case Case.UNCASED -> AttributesConfig.Attribute.Match.UNCASED;
        };
    }

    public void getConfig(AttributesConfig.Builder builder, FieldSet fs, long maxUnCommittedMemory) {
        AttributesConfig.Attribute.Builder attrBuilder;
        for (Attribute attribute : this.attributes.values()) {
            if (!this.isAttributeInFieldSet(attribute, fs)) continue;
            attrBuilder = this.getConfig(attribute.getName(), attribute, false);
            attrBuilder.maxuncommittedmemory(maxUnCommittedMemory);
            builder.attribute(attrBuilder);
        }
        if (fs == FieldSet.ALL) {
            for (Map.Entry entry : this.importedAttributes.entrySet()) {
                attrBuilder = this.getConfig((String)entry.getKey(), (Attribute)entry.getValue(), true);
                attrBuilder.maxuncommittedmemory(maxUnCommittedMemory);
                builder.attribute(attrBuilder);
            }
        }
    }

    public static enum FieldSet {
        ALL,
        FAST_ACCESS;

    }
}

