/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.ssl;

import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.ssl.impl.CloudSslContextProvider;
import com.yahoo.jdisc.http.ssl.impl.ConfiguredSslContextFactoryProvider;
import com.yahoo.vespa.model.container.http.ssl.SslProvider;
import java.util.Optional;

public class CloudSslProvider
extends SslProvider {
    public static final String COMPONENT_ID_PREFIX = "configured-ssl-provider@";
    public static final String MTLSONLY_COMPONENT_CLASS = ConfiguredSslContextFactoryProvider.class.getName();
    public static final String TOKEN_COMPONENT_CLASS = CloudSslContextProvider.class.getName();
    private final String privateKey;
    private final String certificate;
    private final String caCertificatePath;
    private final String caCertificate;
    private final ConnectorConfig.Ssl.ClientAuth.Enum clientAuthentication;

    public CloudSslProvider(String servername, String privateKey, String certificate, String caCertificatePath, String caCertificate, ConnectorConfig.Ssl.ClientAuth.Enum clientAuthentication, boolean enableTokenSupport) {
        super(COMPONENT_ID_PREFIX, servername, CloudSslProvider.componentClass(enableTokenSupport), null);
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.caCertificatePath = caCertificatePath;
        this.caCertificate = caCertificate;
        this.clientAuthentication = clientAuthentication;
    }

    private static String componentClass(boolean enableTokenSupport) {
        return enableTokenSupport ? TOKEN_COMPONENT_CLASS : MTLSONLY_COMPONENT_CLASS;
    }

    @Override
    public void amendConnectorConfig(ConnectorConfig.Builder builder) {
        builder.ssl.enabled(true);
        builder.ssl.privateKey(this.privateKey);
        builder.ssl.certificate(this.certificate);
        builder.ssl.caCertificateFile(Optional.ofNullable(this.caCertificatePath).orElse(""));
        builder.ssl.caCertificate(Optional.ofNullable(this.caCertificate).orElse(""));
        builder.ssl.clientAuth(this.clientAuthentication);
    }
}

