/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.embedding.huggingface.HuggingFaceEmbedderConfig;
import com.yahoo.vespa.model.container.component.TypedComponent;
import com.yahoo.vespa.model.container.xml.ModelIdResolver;
import java.util.Optional;
import org.w3c.dom.Element;

public class HuggingFaceEmbedder
extends TypedComponent
implements HuggingFaceEmbedderConfig.Producer {
    private final ModelReference model;
    private final ModelReference vocab;
    private final Integer maxTokens;
    private final String transformerInputIds;
    private final String transformerAttentionMask;
    private final String transformerTokenTypeIds;
    private final String transformerOutput;
    private final Boolean normalize;
    private final String onnxExecutionMode;
    private final Integer onnxInteropThreads;
    private final Integer onnxIntraopThreads;
    private final Integer onnxGpuDevice;
    private final String poolingStrategy;

    public HuggingFaceEmbedder(Element xml, DeployState state) {
        super("ai.vespa.embedding.huggingface.HuggingFaceEmbedder", "model-integration", xml);
        Element transformerModelElem = XmlHelper.getOptionalChild(xml, "transformer-model").orElseThrow();
        this.model = ModelIdResolver.resolveToModelReference(transformerModelElem, state);
        this.vocab = XmlHelper.getOptionalChild(xml, "tokenizer-model").map(elem -> ModelIdResolver.resolveToModelReference(elem, state)).orElseGet(() -> HuggingFaceEmbedder.resolveDefaultVocab(transformerModelElem, state));
        this.maxTokens = XmlHelper.getOptionalChildValue(xml, "max-tokens").map(Integer::parseInt).orElse(null);
        this.transformerInputIds = XmlHelper.getOptionalChildValue(xml, "transformer-input-ids").orElse(null);
        this.transformerAttentionMask = XmlHelper.getOptionalChildValue(xml, "transformer-attention-mask").orElse(null);
        this.transformerTokenTypeIds = XmlHelper.getOptionalChildValue(xml, "transformer-token-type-ids").orElse(null);
        this.transformerOutput = XmlHelper.getOptionalChildValue(xml, "transformer-output").orElse(null);
        this.normalize = XmlHelper.getOptionalChildValue(xml, "normalize").map(Boolean::parseBoolean).orElse(null);
        this.onnxExecutionMode = XmlHelper.getOptionalChildValue(xml, "onnx-execution-mode").orElse(null);
        this.onnxInteropThreads = XmlHelper.getOptionalChildValue(xml, "onnx-interop-threads").map(Integer::parseInt).orElse(null);
        this.onnxIntraopThreads = XmlHelper.getOptionalChildValue(xml, "onnx-intraop-threads").map(Integer::parseInt).orElse(null);
        this.onnxGpuDevice = XmlHelper.getOptionalChildValue(xml, "onnx-gpu-device").map(Integer::parseInt).orElse(null);
        this.poolingStrategy = XmlHelper.getOptionalChildValue(xml, "pooling-strategy").orElse(null);
    }

    private static ModelReference resolveDefaultVocab(Element model, DeployState state) {
        if (state.isHosted() && model.hasAttribute("model-id")) {
            String implicitVocabId = model.getAttribute("model-id") + "-vocab";
            return ModelIdResolver.resolveToModelReference("tokenizer-model", Optional.of(implicitVocabId), Optional.empty(), Optional.empty(), state);
        }
        throw new IllegalArgumentException("'tokenizer-model' must be specified");
    }

    public void getConfig(HuggingFaceEmbedderConfig.Builder b) {
        b.transformerModel(this.model).tokenizerPath(this.vocab);
        if (this.maxTokens != null) {
            b.transformerMaxTokens(this.maxTokens.intValue());
        }
        if (this.transformerInputIds != null) {
            b.transformerInputIds(this.transformerInputIds);
        }
        if (this.transformerAttentionMask != null) {
            b.transformerAttentionMask(this.transformerAttentionMask);
        }
        if (this.transformerTokenTypeIds != null) {
            b.transformerTokenTypeIds(this.transformerTokenTypeIds);
        }
        if (this.transformerOutput != null) {
            b.transformerOutput(this.transformerOutput);
        }
        if (this.normalize != null) {
            b.normalize(this.normalize.booleanValue());
        }
        if (this.onnxExecutionMode != null) {
            b.transformerExecutionMode(HuggingFaceEmbedderConfig.TransformerExecutionMode.Enum.valueOf((String)this.onnxExecutionMode));
        }
        if (this.onnxInteropThreads != null) {
            b.transformerInterOpThreads(this.onnxInteropThreads.intValue());
        }
        if (this.onnxIntraopThreads != null) {
            b.transformerIntraOpThreads(this.onnxIntraopThreads.intValue());
        }
        if (this.onnxGpuDevice != null) {
            b.transformerGpuDevice(this.onnxGpuDevice.intValue());
        }
        if (this.poolingStrategy != null) {
            b.poolingStrategy(HuggingFaceEmbedderConfig.PoolingStrategy.Enum.valueOf((String)this.poolingStrategy));
        }
    }
}

