/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.config.ModelReference;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.embedding.BertBaseEmbedderConfig;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.container.component.TypedComponent;
import com.yahoo.vespa.model.container.xml.ModelIdResolver;
import org.w3c.dom.Element;

public class BertEmbedder
extends TypedComponent
implements BertBaseEmbedderConfig.Producer {
    private final ModelReference model;
    private final ModelReference vocab;
    private final Integer maxTokens;
    private final String transformerInputIds;
    private final String transformerAttentionMask;
    private final String transformerTokenTypeIds;
    private final String transformerOutput;
    private final Integer tranformerStartSequenceToken;
    private final Integer transformerEndSequenceToken;
    private final String poolingStrategy;
    private final String onnxExecutionMode;
    private final Integer onnxInteropThreads;
    private final Integer onnxIntraopThreads;
    private final Integer onnxGpuDevice;

    public BertEmbedder(Element xml, DeployState state) {
        super("ai.vespa.embedding.BertBaseEmbedder", "model-integration", xml);
        this.model = ModelIdResolver.resolveToModelReference(XML.getChild((Element)xml, (String)"transformer-model"), state);
        this.vocab = ModelIdResolver.resolveToModelReference(XML.getChild((Element)xml, (String)"tokenizer-vocab"), state);
        this.maxTokens = XmlHelper.getOptionalChildValue(xml, "max-tokens").map(Integer::parseInt).orElse(null);
        this.transformerInputIds = XmlHelper.getOptionalChildValue(xml, "transformer-input-ids").orElse(null);
        this.transformerAttentionMask = XmlHelper.getOptionalChildValue(xml, "transformer-attention-mask").orElse(null);
        this.transformerTokenTypeIds = XmlHelper.getOptionalChildValue(xml, "transformer-token-type-ids").orElse(null);
        this.transformerOutput = XmlHelper.getOptionalChildValue(xml, "transformer-output").orElse(null);
        this.tranformerStartSequenceToken = XmlHelper.getOptionalChildValue(xml, "transformer-start-sequence-token").map(Integer::parseInt).orElse(null);
        this.transformerEndSequenceToken = XmlHelper.getOptionalChildValue(xml, "transformer-end-sequence-token").map(Integer::parseInt).orElse(null);
        this.poolingStrategy = XmlHelper.getOptionalChildValue(xml, "pooling-strategy").orElse(null);
        this.onnxExecutionMode = XmlHelper.getOptionalChildValue(xml, "onnx-execution-mode").orElse(null);
        this.onnxInteropThreads = XmlHelper.getOptionalChildValue(xml, "onnx-interop-threads").map(Integer::parseInt).orElse(null);
        this.onnxIntraopThreads = XmlHelper.getOptionalChildValue(xml, "onnx-intraop-threads").map(Integer::parseInt).orElse(null);
        this.onnxGpuDevice = XmlHelper.getOptionalChildValue(xml, "onnx-gpu-device").map(Integer::parseInt).orElse(null);
    }

    public void getConfig(BertBaseEmbedderConfig.Builder b) {
        b.transformerModel(this.model).tokenizerVocab(this.vocab);
        if (this.maxTokens != null) {
            b.transformerMaxTokens(this.maxTokens.intValue());
        }
        if (this.transformerInputIds != null) {
            b.transformerInputIds(this.transformerInputIds);
        }
        if (this.transformerAttentionMask != null) {
            b.transformerAttentionMask(this.transformerAttentionMask);
        }
        if (this.transformerTokenTypeIds != null) {
            b.transformerTokenTypeIds(this.transformerTokenTypeIds);
        }
        if (this.transformerOutput != null) {
            b.transformerOutput(this.transformerOutput);
        }
        if (this.tranformerStartSequenceToken != null) {
            b.transformerStartSequenceToken(this.tranformerStartSequenceToken.intValue());
        }
        if (this.transformerEndSequenceToken != null) {
            b.transformerEndSequenceToken(this.transformerEndSequenceToken.intValue());
        }
        if (this.poolingStrategy != null) {
            b.poolingStrategy(BertBaseEmbedderConfig.PoolingStrategy.Enum.valueOf((String)this.poolingStrategy));
        }
        if (this.onnxExecutionMode != null) {
            b.onnxExecutionMode(BertBaseEmbedderConfig.OnnxExecutionMode.Enum.valueOf((String)this.onnxExecutionMode));
        }
        if (this.onnxInteropThreads != null) {
            b.onnxInterOpThreads(this.onnxInteropThreads.intValue());
        }
        if (this.onnxIntraopThreads != null) {
            b.onnxIntraOpThreads(this.onnxIntraopThreads.intValue());
        }
        if (this.onnxGpuDevice != null) {
            b.onnxGpuDevice(this.onnxGpuDevice.intValue());
        }
    }
}

