/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.vespa.config.content.core.StorCommunicationmanagerConfig;
import com.yahoo.vespa.config.content.core.StorServerConfig;
import com.yahoo.vespa.config.content.core.StorStatusConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.application.validation.RestartConfigs;

@RestartConfigs(value={StorCommunicationmanagerConfig.class, StorStatusConfig.class, StorServerConfig.class, MetricsmanagerConfig.class})
public abstract class ContentNode
extends AbstractService
implements StorCommunicationmanagerConfig.Producer,
StorStatusConfig.Producer,
StorServerConfig.Producer {
    private final int distributionKey;
    private final String rootDirectory;
    private final int mbus_network_threads;
    private final int mbus_rpc_targets;
    private final int mbus_events_before_wakeup;
    private final int rpc_num_targets;
    private final int rpc_events_before_wakeup;

    public ContentNode(ModelContext.FeatureFlags featureFlags, TreeConfigProducer<?> parent, String clusterName, String rootDirectory, int distributionKey) {
        super(parent, "" + distributionKey);
        this.distributionKey = distributionKey;
        this.rootDirectory = rootDirectory;
        this.mbus_network_threads = featureFlags.mbusNetworkThreads();
        this.mbus_rpc_targets = featureFlags.mbusCppRpcNumTargets();
        this.mbus_events_before_wakeup = featureFlags.mbusCppEventsBeforeWakeup();
        this.rpc_num_targets = featureFlags.rpcNumTargets();
        this.rpc_events_before_wakeup = featureFlags.rpcEventsBeforeWakeup();
        this.initialize();
        this.setProp("clustertype", "content");
        this.setProp("clustername", clusterName);
        this.setProp("index", distributionKey);
    }

    public int getDistributionKey() {
        return this.distributionKey;
    }

    public void getConfig(StorServerConfig.Builder builder) {
        builder.root_folder(this.rootDirectory);
        builder.node_index(this.distributionKey);
    }

    private void initialize() {
        this.portsMeta.on(0).tag("messaging");
        this.portsMeta.on(1).tag("rpc").tag("status");
        this.portsMeta.on(2).tag("http").tag("status").tag("state");
    }

    @Override
    public int getPortCount() {
        return 3;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        if (start == 0) {
            from.allocatePort("messaging");
            from.allocatePort("rpc");
            from.allocatePort("http");
        } else {
            from.wantPort(start++, "messaging");
            from.wantPort(start++, "rpc");
            from.wantPort(start++, "http");
        }
    }

    public void getConfig(StorCommunicationmanagerConfig.Builder builder) {
        builder.mbusport(this.getRelativePort(0));
        builder.rpcport(this.getRelativePort(1));
        builder.mbus.num_network_threads(this.mbus_network_threads);
        builder.mbus.num_rpc_targets(this.mbus_rpc_targets);
        builder.mbus.events_before_wakeup(this.mbus_events_before_wakeup);
        builder.rpc.num_targets_per_node(this.rpc_num_targets);
        builder.rpc.events_before_wakeup(this.rpc_events_before_wakeup);
    }

    public void getConfig(StorStatusConfig.Builder builder) {
        builder.httpport(this.getRelativePort(2));
    }

    @Override
    public int getHealthPort() {
        return this.getRelativePort(2);
    }
}

