/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http;

import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.vespa.model.container.component.chain.ChainedComponent;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.ConnectorFactory;
import com.yahoo.vespa.model.container.http.FilterBinding;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class Http
extends TreeConfigProducer<AnyConfigProducer>
implements ServerConfig.Producer {
    private final FilterChains filterChains;
    private final List<FilterBinding> bindings = new CopyOnWriteArrayList<FilterBinding>();
    private volatile JettyHttpServer httpServer;
    private volatile AccessControl accessControl;
    private volatile Boolean strictFiltering;

    public Http(FilterChains chains) {
        super("http");
        this.filterChains = chains;
    }

    public void setAccessControl(AccessControl accessControl) {
        if (this.accessControl != null) {
            throw new IllegalStateException("Access control already assigned");
        }
        this.accessControl = accessControl;
    }

    public FilterChains getFilterChains() {
        return this.filterChains;
    }

    public Optional<JettyHttpServer> getHttpServer() {
        return Optional.ofNullable(this.httpServer);
    }

    public void setHttpServer(JettyHttpServer newServer) {
        JettyHttpServer oldServer = this.httpServer;
        this.httpServer = newServer;
        if (oldServer == null && newServer != null) {
            this.addChild(newServer);
        } else if (newServer == null && oldServer != null) {
            this.removeChild(oldServer);
        } else if (newServer != null || oldServer != null) {
            this.removeChild(oldServer);
            this.addChild(newServer);
        }
    }

    public void removeAllServers() {
        this.setHttpServer(null);
    }

    public List<FilterBinding> getBindings() {
        return this.bindings;
    }

    public Optional<AccessControl> getAccessControl() {
        return Optional.ofNullable(this.accessControl);
    }

    public void setStrictFiltering(boolean enabled) {
        this.strictFiltering = enabled;
    }

    public void getConfig(ServerConfig.Builder builder) {
        for (FilterBinding binding : this.bindings) {
            builder.filter(new ServerConfig.Filter.Builder().id(binding.chainId().stringValue()).binding(binding.binding().patternString()));
        }
        Http.populateDefaultFiltersConfig(builder, this.httpServer);
        boolean strictFilter = this.strictFiltering == null ? !this.bindings.isEmpty() || !this.filterChains.allChains().allComponents().isEmpty() : this.strictFiltering;
        builder.strictFiltering(strictFilter);
    }

    @Override
    public void validate() {
        if (this.bindings.isEmpty()) {
            return;
        }
        if (this.filterChains == null) {
            throw new IllegalArgumentException("Null FilterChains are not allowed when there are filter bindings");
        }
        ComponentRegistry<ChainedComponent<?>> filters = this.filterChains.componentsRegistry();
        ComponentRegistry chains = this.filterChains.allChains();
        for (FilterBinding binding : this.bindings) {
            if (filters.getComponent(binding.chainId()) != null || chains.getComponent(binding.chainId()) != null) continue;
            throw new IllegalArgumentException("Can't find filter " + binding.chainId() + " for binding " + binding.binding());
        }
    }

    private static void populateDefaultFiltersConfig(ServerConfig.Builder builder, JettyHttpServer httpServer) {
        if (httpServer != null) {
            for (ConnectorFactory connector : httpServer.getConnectorFactories()) {
                connector.getDefaultRequestFilterChain().ifPresent(filterChain -> builder.defaultFilters(new ServerConfig.DefaultFilters.Builder().filterId(filterChain.stringValue()).localPort(connector.getListenPort())));
                connector.getDefaultResponseFilterChain().ifPresent(filterChain -> builder.defaultFilters(new ServerConfig.DefaultFilters.Builder().filterId(filterChain.stringValue()).localPort(connector.getListenPort())));
            }
        }
    }
}

