/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedDocument;
import com.yahoo.schema.parser.ParsedField;
import com.yahoo.schema.parser.ParsedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParsedStruct
extends ParsedBlock {
    private final List<String> inherited = new ArrayList<String>();
    private final List<ParsedStruct> resolvedInherits = new ArrayList<ParsedStruct>();
    private final Map<String, ParsedField> fields = new LinkedHashMap<String, ParsedField>();
    private final ParsedType asParsedType;
    private ParsedDocument ownedBy = null;

    public ParsedStruct(String name) {
        super(name, "struct");
        this.asParsedType = ParsedType.fromName(name);
        this.asParsedType.setVariant(ParsedType.Variant.STRUCT);
    }

    List<ParsedField> getFields() {
        return List.copyOf(this.fields.values());
    }

    List<String> getInherited() {
        return List.copyOf(this.inherited);
    }

    ParsedDocument getOwnerDoc() {
        this.verifyThat(this.ownedBy != null, "not owned by any document", new Object[0]);
        return this.ownedBy;
    }

    String getOwnerName() {
        return this.getOwnerDoc().name();
    }

    String getFullName() {
        return this.name() + " @ " + this.getOwnerName();
    }

    List<ParsedStruct> getResolvedInherits() {
        assert (this.inherited.size() == this.resolvedInherits.size());
        return List.copyOf(this.resolvedInherits);
    }

    void addField(ParsedField field) {
        String fieldName = field.name();
        this.verifyThat(!this.fields.containsKey(fieldName), "already has field", fieldName);
        this.fields.put(fieldName, field);
    }

    void inherit(String other) {
        this.verifyThat(!this.name().equals(other), "cannot inherit from itself", new Object[0]);
        this.inherited.add(other);
    }

    void tagOwner(ParsedDocument document) {
        this.verifyThat(this.ownedBy == null, "already owned by document " + this.ownedBy, new Object[0]);
        this.ownedBy = document;
    }

    void resolveInherit(String name, ParsedStruct parsed) {
        this.verifyThat(this.inherited.contains(name), "resolveInherit for non-inherited name", name);
        this.verifyThat(name.equals(parsed.name()), "resolveInherit name mismatch for", name);
        this.resolvedInherits.add(parsed);
    }
}

