/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.model.ConfigModelRepoAdder;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterInfo;
import com.yahoo.vespa.model.VespaModel;
import java.time.Duration;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;

public final class ConfigModelContext {
    private final TreeConfigProducer<AnyConfigProducer> parent;
    private final String producerId;
    private final DeployState deployState;
    private final VespaModel vespaModel;
    private final ConfigModelRepoAdder configModelRepoAdder;
    private final ApplicationType applicationType;

    private ConfigModelContext(ApplicationType applicationType, DeployState deployState, VespaModel vespaModel, ConfigModelRepoAdder configModelRepoAdder, TreeConfigProducer<AnyConfigProducer> parent, String producerId) {
        this.applicationType = applicationType;
        this.deployState = deployState;
        this.vespaModel = vespaModel;
        this.configModelRepoAdder = configModelRepoAdder;
        this.parent = parent;
        this.producerId = producerId;
    }

    public ApplicationPackage getApplicationPackage() {
        return this.deployState.getApplicationPackage();
    }

    public String getProducerId() {
        return this.producerId;
    }

    public TreeConfigProducer<AnyConfigProducer> getParentProducer() {
        return this.parent;
    }

    public DeployLogger getDeployLogger() {
        return this.deployState.getDeployLogger();
    }

    public DeployState getDeployState() {
        return this.deployState;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public VespaModel vespaModel() {
        return this.vespaModel;
    }

    public ModelContext.Properties properties() {
        return this.deployState.getProperties();
    }

    public ModelContext.FeatureFlags featureFlags() {
        return this.deployState.featureFlags();
    }

    public ConfigModelRepoAdder getConfigModelRepoAdder() {
        return this.configModelRepoAdder;
    }

    public ConfigModelContext withParent(TreeConfigProducer<AnyConfigProducer> newParent) {
        return ConfigModelContext.create(this.deployState, this.vespaModel, this.configModelRepoAdder, newParent, this.producerId);
    }

    public ConfigModelContext withId(String producerId) {
        return ConfigModelContext.create(this.deployState, this.vespaModel, this.configModelRepoAdder, this.parent, producerId);
    }

    public ConfigModelContext with(VespaModel vespaModel) {
        return ConfigModelContext.create(this.deployState, vespaModel, this.configModelRepoAdder, this.parent, this.producerId);
    }

    public ClusterInfo.Builder clusterInfo() {
        Optional instance = this.getApplicationPackage().getDeploymentSpec().instance(this.properties().applicationId().instance());
        if (!instance.isPresent()) {
            return new ClusterInfo.Builder();
        }
        Duration maxDeadline = ((DeploymentInstanceSpec)instance.get()).bcp().groups().stream().filter(group -> group.memberRegions().contains(this.properties().zone().region())).map(group -> group.deadline()).min(Comparator.comparing(deadline -> deadline)).orElse(Duration.ofMinutes(0L));
        return new ClusterInfo.Builder().bcpDeadline(maxDeadline);
    }

    public static ConfigModelContext create(DeployState deployState, VespaModel vespaModel, ConfigModelRepoAdder configModelRepoAdder, TreeConfigProducer<AnyConfigProducer> parent, String producerId) {
        return new ConfigModelContext(ApplicationType.DEFAULT, deployState, vespaModel, configModelRepoAdder, parent, producerId);
    }

    public static ConfigModelContext create(ApplicationType applicationType, DeployState deployState, VespaModel vespaModel, ConfigModelRepoAdder configModelRepoAdder, TreeConfigProducer<AnyConfigProducer> parent, String producerId) {
        return new ConfigModelContext(applicationType, deployState, vespaModel, configModelRepoAdder, parent, producerId);
    }

    public static enum ApplicationType {
        DEFAULT("default"),
        HOSTED_INFRASTRUCTURE("hosted-infrastructure");

        private final String type;

        private ApplicationType(String type) {
            this.type = type;
        }

        public static ApplicationType fromString(String value) {
            return Stream.of(ApplicationType.values()).filter(applicationType -> applicationType.type.equals(value)).findFirst().orElse(DEFAULT);
        }
    }
}

