/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.schema.Schema;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.SummaryConfig;
import com.yahoo.vespa.config.search.vsm.VsmfieldsConfig;
import com.yahoo.vespa.config.search.vsm.VsmsummaryConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.SearchCluster;
import java.util.List;

public class StreamingSearchCluster
extends SearchCluster
implements DocumentdbInfoConfig.Producer,
RankProfilesConfig.Producer,
VsmsummaryConfig.Producer,
VsmfieldsConfig.Producer,
SummaryConfig.Producer {
    private final String storageRouteSpec;
    private final AttributesProducer attributesConfig;
    private final String docTypeName;
    private DerivedConfiguration derivedConfig = null;

    public StreamingSearchCluster(TreeConfigProducer<AnyConfigProducer> parent, String clusterName, int index, String docTypeName, String storageRouteSpec) {
        super(parent, clusterName, index);
        this.attributesConfig = new AttributesProducer(parent, docTypeName);
        this.docTypeName = docTypeName;
        this.storageRouteSpec = storageRouteSpec;
    }

    public final String getDocumentDBConfigId() {
        return this.attributesConfig.getConfigId();
    }

    @Override
    protected SearchCluster.IndexingMode getIndexingMode() {
        return SearchCluster.IndexingMode.STREAMING;
    }

    public final String getStorageRouteSpec() {
        return this.storageRouteSpec;
    }

    public String getDocTypeName() {
        return this.docTypeName;
    }

    public DerivedConfiguration derived() {
        return this.derivedConfig;
    }

    @Override
    public int getRowBits() {
        return 0;
    }

    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder();
        docDb.name(this.derivedConfig.getSchema().getName());
        builder.documentdb(docDb);
    }

    @Override
    public void deriveFromSchemas(DeployState deployState) {
        if (this.schemas().isEmpty()) {
            return;
        }
        if (this.schemas().size() > 1) {
            throw new IllegalArgumentException("Only a single schema is supported, got " + this.schemas().size());
        }
        Schema schema = this.schemas().values().stream().findAny().get().fullSchema();
        if (!schema.getName().equals(this.docTypeName)) {
            throw new IllegalArgumentException("Document type name '" + this.docTypeName + "' must be the same as the schema name '" + schema.getName() + "'");
        }
        this.derivedConfig = new DerivedConfiguration(schema, deployState);
    }

    @Override
    public List<DocumentDatabase> getDocumentDbs() {
        if (this.derived() == null) {
            throw new IllegalArgumentException("missing derivedConfig");
        }
        DocumentDatabase db = new DocumentDatabase(this, this.docTypeName, this.derived());
        return List.of(db);
    }

    @Override
    public void defaultDocumentsConfig() {
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        this.derivedConfig.getIndexInfo().getConfig(builder);
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        this.derivedConfig.getSchemaInfo().getConfig(builder);
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        this.derivedConfig.getIndexingScript().getConfig(builder);
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        this.derivedConfig.getConfig(builder);
    }

    @Override
    public void getConfig(RankProfilesConfig.Builder builder) {
        this.derivedConfig.getRankProfileList().getConfig(builder);
    }

    public void getConfig(VsmsummaryConfig.Builder builder) {
        if (this.derivedConfig.getVsmSummary() != null) {
            this.derivedConfig.getVsmSummary().getConfig(builder);
        }
    }

    public void getConfig(VsmfieldsConfig.Builder builder) {
        if (this.derivedConfig.getVsmFields() != null) {
            this.derivedConfig.getVsmFields().getConfig(builder);
        }
    }

    public void getConfig(SummaryConfig.Builder builder) {
        if (this.derivedConfig.getSummaries() != null) {
            this.derivedConfig.getSummaries().getConfig(builder);
        }
    }

    private class AttributesProducer
    extends AnyConfigProducer
    implements AttributesConfig.Producer {
        AttributesProducer(TreeConfigProducer<AnyConfigProducer> parent, String docType) {
            super(parent, docType);
        }

        public void getConfig(AttributesConfig.Builder builder) {
            StreamingSearchCluster.this.derivedConfig.getConfig(builder, AttributeFields.FieldSet.FAST_ACCESS);
        }
    }
}

