/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.cloud.config.CuratorConfig;
import com.yahoo.cloud.config.ZookeeperServerConfig;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.FileReference;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.model.api.ApplicationClusterEndpoint;
import com.yahoo.config.model.api.ApplicationClusterInfo;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.SystemName;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.di.config.ApplicationBundlesConfig;
import com.yahoo.container.handler.metrics.MetricsProxyApiConfig;
import com.yahoo.container.handler.metrics.MetricsV2Handler;
import com.yahoo.container.handler.metrics.PrometheusV1Handler;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.messagebus.MbusServerProvider;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.search.config.QrStartConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.OnnxModelsConfig;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import com.yahoo.vespa.config.search.core.RankingExpressionsConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.container.ApplicationContainer;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModelEvaluation;
import com.yahoo.vespa.model.container.PlatformBundles;
import com.yahoo.vespa.model.container.component.BindingPattern;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.Handler;
import com.yahoo.vespa.model.container.component.SystemBindingPattern;
import com.yahoo.vespa.model.container.configserver.ConfigserverCluster;
import com.yahoo.vespa.model.utils.FileSender;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ApplicationContainerCluster
extends ContainerCluster<ApplicationContainer>
implements ApplicationBundlesConfig.Producer,
QrStartConfig.Producer,
RankProfilesConfig.Producer,
RankingConstantsConfig.Producer,
OnnxModelsConfig.Producer,
RankingExpressionsConfig.Producer,
ContainerMbusConfig.Producer,
MetricsProxyApiConfig.Producer,
ZookeeperServerConfig.Producer,
ApplicationClusterInfo {
    public static final String METRICS_V2_HANDLER_CLASS = MetricsV2Handler.class.getName();
    public static final BindingPattern METRICS_V2_HANDLER_BINDING_1 = SystemBindingPattern.fromHttpPath("/metrics/v2");
    public static final BindingPattern METRICS_V2_HANDLER_BINDING_2 = SystemBindingPattern.fromHttpPath("/metrics/v2/*");
    public static final String PROMETHEUS_V1_HANDLER_CLASS = PrometheusV1Handler.class.getName();
    private static final BindingPattern PROMETHEUS_V1_HANDLER_BINDING_1 = SystemBindingPattern.fromHttpPath("/prometheus/v1");
    private static final BindingPattern PROMETHEUS_V1_HANDLER_BINDING_2 = SystemBindingPattern.fromHttpPath("/prometheus/v1/*");
    public static final int defaultHeapSizePercentageOfTotalNodeMemory = 70;
    public static final int heapSizePercentageOfTotalNodeMemoryWhenCombinedCluster = 18;
    private final Set<FileReference> applicationBundles = new LinkedHashSet<FileReference>();
    private final Set<String> previousHosts;
    private ContainerModelEvaluation modelEvaluation;
    private final Optional<String> tlsClientAuthority;
    private MbusParams mbusParams;
    private boolean messageBusEnabled = true;
    private int zookeeperSessionTimeoutSeconds = 30;
    private final int transport_events_before_wakeup;
    private final int transport_connections_per_target;
    private final int heapSizePercentageOfTotalNodeMemory;
    private Integer memoryPercentage = null;
    private List<ApplicationClusterEndpoint> endpointList = List.of();

    public ApplicationContainerCluster(TreeConfigProducer<?> parent, String configSubId, String clusterId, DeployState deployState) {
        super(parent, configSubId, clusterId, deployState, true, 10);
        this.tlsClientAuthority = deployState.tlsClientAuthority();
        this.previousHosts = Collections.unmodifiableSet(deployState.getPreviousModel().stream().map(Model::allocatedHosts).map(AllocatedHosts::getHosts).flatMap(Collection::stream).map(HostSpec::hostname).collect(Collectors.toCollection(() -> new LinkedHashSet())));
        this.addSimpleComponent("com.yahoo.language.provider.DefaultLinguisticsProvider");
        this.addSimpleComponent("com.yahoo.language.provider.DefaultEmbedderProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.SecretStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.CertificateStoreProvider");
        this.addSimpleComponent("com.yahoo.container.jdisc.AthenzIdentityProviderProvider");
        this.addSimpleComponent("com.yahoo.container.core.documentapi.DocumentAccessProvider");
        this.addSimpleComponent("com.yahoo.document.DocumentTypeManager");
        this.addMetricsHandlers();
        this.addTestrunnerComponentsIfTester(deployState);
        this.transport_connections_per_target = deployState.featureFlags().mbusJavaRpcNumTargets();
        this.transport_events_before_wakeup = deployState.featureFlags().mbusJavaEventsBeforeWakeup();
        this.heapSizePercentageOfTotalNodeMemory = deployState.featureFlags().heapSizePercentage() > 0 ? Math.min(99, deployState.featureFlags().heapSizePercentage()) : 70;
    }

    @Override
    protected void doPrepare(DeployState deployState) {
        super.doPrepare(deployState);
        this.addAndSendApplicationBundles(deployState);
        this.sendUserConfiguredFiles(deployState);
        this.createEndpointList(deployState);
    }

    private void addAndSendApplicationBundles(DeployState deployState) {
        for (ComponentInfo component : deployState.getApplicationPackage().getComponentsInfo(deployState.getVespaVersion())) {
            FileReference reference = deployState.getFileRegistry().addFile(component.getPathRelativeToAppDir());
            this.applicationBundles.add(reference);
        }
    }

    private void sendUserConfiguredFiles(DeployState deployState) {
        FileSender fileSender = new FileSender(this.containers, deployState.getFileRegistry(), deployState.getDeployLogger());
        for (Component<?, ?> component : this.getAllComponents()) {
            fileSender.sendUserConfiguredFiles(component);
        }
    }

    private void addMetricsHandlers() {
        this.addMetricsHandler(METRICS_V2_HANDLER_CLASS, METRICS_V2_HANDLER_BINDING_1, METRICS_V2_HANDLER_BINDING_2);
        this.addMetricsHandler(PROMETHEUS_V1_HANDLER_CLASS, PROMETHEUS_V1_HANDLER_BINDING_1, PROMETHEUS_V1_HANDLER_BINDING_2);
    }

    private void addMetricsHandler(String handlerClass, BindingPattern rootBinding, BindingPattern innerBinding) {
        Handler handler = new Handler(new ComponentModel(handlerClass, null, null, null));
        handler.addServerBindings(rootBinding, innerBinding);
        this.addComponent(handler);
    }

    private void addTestrunnerComponentsIfTester(DeployState deployState) {
        if (deployState.isHosted() && deployState.getProperties().applicationId().instance().isTester()) {
            this.addPlatformBundle(PlatformBundles.absoluteBundlePath("vespa-testrunner-components"));
            this.addPlatformBundle(PlatformBundles.absoluteBundlePath("vespa-osgi-testrunner"));
            this.addPlatformBundle(PlatformBundles.absoluteBundlePath("tenant-cd-api"));
            if (deployState.zone().system().isPublic()) {
                this.addPlatformBundle(PlatformBundles.absoluteBundlePath("cloud-tenant-cd"));
            }
        }
    }

    public void setModelEvaluation(ContainerModelEvaluation modelEvaluation) {
        this.modelEvaluation = modelEvaluation;
    }

    public void setMemoryPercentage(Integer memoryPercentage) {
        this.memoryPercentage = memoryPercentage;
    }

    @Override
    public Optional<Integer> getMemoryPercentage() {
        if (this.memoryPercentage != null) {
            return Optional.of(this.memoryPercentage);
        }
        if (this.isHostedVespa()) {
            return this.getHostClusterId().isPresent() ? Optional.of(18) : Optional.of(this.heapSizePercentageOfTotalNodeMemory);
        }
        return Optional.empty();
    }

    private void createEndpointList(DeployState deployState) {
        if (!deployState.isHosted()) {
            return;
        }
        if (deployState.getProperties().applicationId().instance().isTester()) {
            return;
        }
        ArrayList<ApplicationClusterEndpoint> endpoints = new ArrayList<ApplicationClusterEndpoint>();
        List<String> hosts = this.getContainers().stream().map(AbstractService::getHostName).sorted().toList();
        for (String suffix : deployState.getProperties().zoneDnsSuffixes()) {
            ApplicationClusterEndpoint.DnsName l4Name = ApplicationClusterEndpoint.DnsName.sharedL4NameFrom((SystemName)deployState.zone().system(), (ClusterSpec.Id)ClusterSpec.Id.from((String)this.getName()), (ApplicationId)deployState.getProperties().applicationId(), (String)suffix);
            endpoints.add(ApplicationClusterEndpoint.builder().zoneScope().sharedL4Routing().dnsName(l4Name).hosts(hosts).clusterId(this.getName()).build());
        }
        Set<ContainerEndpoint> endpointsFromController = deployState.getEndpoints();
        endpointsFromController.stream().filter(ce -> ce.clusterId().equals(this.getName())).filter(ce -> ce.routingMethod() == ApplicationClusterEndpoint.RoutingMethod.sharedLayer4).forEach(ce -> ce.names().forEach(name -> endpoints.add(ApplicationClusterEndpoint.builder().scope(ce.scope()).weight(Long.valueOf(ce.weight().orElse(1)).intValue()).routingMethod(ce.routingMethod()).dnsName(ApplicationClusterEndpoint.DnsName.from((String)name)).hosts(hosts).clusterId(this.getName()).build())));
        this.endpointList = List.copyOf(endpoints);
    }

    public void getConfig(ApplicationBundlesConfig.Builder builder) {
        this.applicationBundles.stream().map(FileReference::value).forEach(arg_0 -> ((ApplicationBundlesConfig.Builder)builder).bundles(arg_0));
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(RankingConstantsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(OnnxModelsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(RankingExpressionsConfig.Builder builder) {
        if (this.modelEvaluation != null) {
            this.modelEvaluation.getConfig(builder);
        }
    }

    public void getConfig(ContainerMbusConfig.Builder builder) {
        if (this.mbusParams != null) {
            if (this.mbusParams.maxConcurrentFactor != null) {
                builder.maxConcurrentFactor(this.mbusParams.maxConcurrentFactor.doubleValue());
            }
            if (this.mbusParams.documentExpansionFactor != null) {
                builder.documentExpansionFactor(this.mbusParams.documentExpansionFactor.doubleValue());
            }
            if (this.mbusParams.containerCoreMemory != null) {
                builder.containerCoreMemory(this.mbusParams.containerCoreMemory.intValue());
            }
        }
        if (this.getDocproc() != null) {
            this.getDocproc().getConfig(builder);
        }
        builder.transport_events_before_wakeup(this.transport_events_before_wakeup);
        builder.numconnectionspertarget(this.transport_connections_per_target);
    }

    public void getConfig(MetricsProxyApiConfig.Builder builder) {
        builder.metricsPort(19092).metricsApiPath("/applicationmetrics/v1/values").prometheusApiPath("/applicationmetrics/v1/prometheus");
    }

    @Override
    public void getConfig(QrStartConfig.Builder builder) {
        super.getConfig(builder);
        builder.jvm.verbosegc(true).availableProcessors(0).compressedClassSpaceSize(0).minHeapsize(1536).heapsize(1536);
        if (this.getMemoryPercentage().isPresent()) {
            builder.jvm.heapSizeAsPercentageOfPhysicalMemory(this.getMemoryPercentage().get().intValue());
        }
    }

    public void getConfig(ZookeeperServerConfig.Builder builder) {
        if (this.getParent() instanceof ConfigserverCluster) {
            return;
        }
        for (Container container : this.getContainers()) {
            ZookeeperServerConfig.Server.Builder serverBuilder = new ZookeeperServerConfig.Server.Builder();
            serverBuilder.hostname(container.getHostName()).id(container.index()).joining(!this.previousHosts.isEmpty() && !this.previousHosts.contains(container.getHostName())).retired(container.isRetired());
            builder.server(serverBuilder);
        }
        builder.dynamicReconfiguration(true);
    }

    @Override
    public void getConfig(CuratorConfig.Builder builder) {
        super.getConfig(builder);
        if (this.getParent() instanceof ConfigserverCluster) {
            return;
        }
        builder.zookeeperSessionTimeoutSeconds(this.zookeeperSessionTimeoutSeconds);
    }

    public Optional<String> getTlsClientAuthority() {
        return this.tlsClientAuthority;
    }

    public void setMbusParams(MbusParams mbusParams) {
        this.mbusParams = mbusParams;
    }

    public void setMessageBusEnabled(boolean messageBusEnabled) {
        this.messageBusEnabled = messageBusEnabled;
    }

    public void setZookeeperSessionTimeoutSeconds(int timeoutSeconds) {
        this.zookeeperSessionTimeoutSeconds = timeoutSeconds;
    }

    @Override
    protected boolean messageBusEnabled() {
        return this.messageBusEnabled;
    }

    public void addMbusServer(ComponentId chainId) {
        ComponentId serviceId = chainId.nestInNamespace(ComponentId.fromString((String)"MbusServer"));
        this.addComponent(new Component(new ComponentModel(new BundleInstantiationSpecification(serviceId, ComponentSpecification.fromString((String)MbusServerProvider.class.getName()), null))));
    }

    public List<ApplicationClusterEndpoint> endpoints() {
        return this.endpointList;
    }

    public String name() {
        return this.getName();
    }

    public static class MbusParams {
        final Double maxConcurrentFactor;
        final Double documentExpansionFactor;
        final Integer containerCoreMemory;

        public MbusParams(Double maxConcurrentFactor, Double documentExpansionFactor, Integer containerCoreMemory) {
            this.maxConcurrentFactor = maxConcurrentFactor;
            this.documentExpansionFactor = documentExpansionFactor;
            this.containerCoreMemory = containerCoreMemory;
        }
    }
}

