/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.ArrayList;
import java.util.List;

public class ContentClusterRemovalValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, DeployState deployState) {
        ArrayList<ConfigChangeAction> actions = new ArrayList<ConfigChangeAction>();
        for (String currentClusterId : current.getContentClusters().keySet()) {
            ContentCluster nextCluster = next.getContentClusters().get(currentClusterId);
            if (nextCluster != null) continue;
            deployState.validationOverrides().invalid(ValidationId.contentClusterRemoval, "Content cluster '" + currentClusterId + "' is removed. This will cause loss of all data in this cluster", deployState.now());
            for (ApplicationContainerCluster cluster : next.getContainerClusters().values()) {
                actions.add(new VespaRestartAction(cluster.id(), "Content cluster '" + currentClusterId + "' has been removed", cluster.getContainers().stream().map(AbstractService::getServiceInfo).toList()));
            }
        }
        return actions;
    }
}

