/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import com.yahoo.metrics.ContainerMetrics;
import com.yahoo.metrics.SearchNodeMetrics;
import com.yahoo.metrics.Suffix;
import com.yahoo.metrics.VespaMetrics;
import com.yahoo.vespa.model.admin.monitoring.DefaultVespaMetrics;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultMetrics {
    public static final String defaultMetricSetId = "default";
    public static final MetricSet defaultMetricSet = DefaultMetrics.createMetricSet();

    private static MetricSet createMetricSet() {
        return new MetricSet(defaultMetricSetId, DefaultMetrics.getAllMetrics(), Set.of(DefaultVespaMetrics.defaultVespaMetricSet));
    }

    private static Set<Metric> getAllMetrics() {
        LinkedHashSet<Metric> metrics = new LinkedHashSet<Metric>();
        DefaultMetrics.addContentMetrics(metrics);
        DefaultMetrics.addContainerMetrics(metrics);
        DefaultMetrics.addSearchChainMetrics(metrics);
        return Collections.unmodifiableSet(metrics);
    }

    private static void addContainerMetrics(Set<Metric> metrics) {
        DefaultMetrics.addMetric(metrics, ContainerMetrics.HTTP_STATUS_1XX.rate());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.HTTP_STATUS_2XX.rate());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.HTTP_STATUS_3XX.rate());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.HTTP_STATUS_4XX.rate());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.HTTP_STATUS_5XX.rate());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.JDISC_GC_MS.average());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.MEM_HEAP_FREE.average());
    }

    private static void addSearchChainMetrics(Set<Metric> metrics) {
        DefaultMetrics.addMetric(metrics, ContainerMetrics.QUERIES.rate());
        DefaultMetrics.addMetric(metrics, (VespaMetrics)ContainerMetrics.QUERY_LATENCY, EnumSet.of(Suffix.sum, new Suffix[]{Suffix.count, Suffix.max, Suffix.ninety_five_percentile, Suffix.ninety_nine_percentile, Suffix.average}));
        DefaultMetrics.addMetric(metrics, (VespaMetrics)ContainerMetrics.HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average));
        DefaultMetrics.addMetric(metrics, (VespaMetrics)ContainerMetrics.TOTAL_HITS_PER_QUERY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average));
        DefaultMetrics.addMetric(metrics, ContainerMetrics.DEGRADED_QUERIES.rate());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.FAILED_QUERIES.rate());
        DefaultMetrics.addMetric(metrics, ContainerMetrics.SERVER_ACTIVE_THREADS.average());
    }

    private static void addContentMetrics(Set<Metric> metrics) {
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_REQUESTED_DOCUMENTS.rate());
        DefaultMetrics.addMetric(metrics, (VespaMetrics)SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_DOCSUM_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average));
        DefaultMetrics.addMetric(metrics, (VespaMetrics)SearchNodeMetrics.CONTENT_PROTON_SEARCH_PROTOCOL_QUERY_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average));
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_TOTAL.last());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_READY.last());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DOCUMENTS_ACTIVE.last());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_DISK_USAGE.last());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MEMORY_USAGE_ALLOCATED_BYTES.last());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_DISK.average());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_RESOURCE_USAGE_MEMORY.average());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_DOCS_MATCHED.rate());
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_DOCS_RERANKED.rate());
        DefaultMetrics.addMetric(metrics, (VespaMetrics)SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_SETUP_TIME, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average));
        DefaultMetrics.addMetric(metrics, (VespaMetrics)SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_QUERY_LATENCY, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average));
        DefaultMetrics.addMetric(metrics, (VespaMetrics)SearchNodeMetrics.CONTENT_PROTON_DOCUMENTDB_MATCHING_RANK_PROFILE_RERANK_TIME, EnumSet.of(Suffix.sum, Suffix.count, Suffix.max, Suffix.average));
        DefaultMetrics.addMetric(metrics, SearchNodeMetrics.CONTENT_PROTON_TRANSACTIONLOG_DISK_USAGE.last());
    }

    private static void addMetric(Set<Metric> metrics, String nameWithSuffix) {
        metrics.add(new Metric(nameWithSuffix));
    }

    private static void addMetric(Set<Metric> metrics, VespaMetrics metric, EnumSet<Suffix> suffixes) {
        suffixes.forEach(suffix -> metrics.add(new Metric(metric.baseName() + "." + suffix.suffix())));
    }

    private DefaultMetrics() {
    }
}

