/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.MapEvaluationTypeContext;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.processing.Processor;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RankingExpressionTypeResolver
extends Processor {
    private final QueryProfileRegistry queryProfiles;

    public RankingExpressionTypeResolver(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
        this.queryProfiles = queryProfiles.getRegistry();
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (documentsOnly) {
            return;
        }
        HashSet<Reference> warnedAbout = new HashSet<Reference>();
        for (RankProfile profile : this.rankProfileRegistry.rankProfilesOf(this.schema)) {
            try {
                this.resolveTypesIn(profile, validate, warnedAbout);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("In " + (String)(this.schema != null ? this.schema + ", " : "") + profile, e);
            }
        }
    }

    private void resolveTypesIn(RankProfile profile, boolean validate, Set<Reference> warnedAbout) {
        MapEvaluationTypeContext context = profile.typeContext(this.queryProfiles);
        for (Map.Entry<String, RankProfile.RankingExpressionFunction> function : profile.getFunctions().entrySet()) {
            ExpressionFunction expressionFunction = function.getValue().function();
            if (this.hasUntypedArguments(expressionFunction)) continue;
            for (String argument : expressionFunction.arguments()) {
                Reference ref = Reference.fromIdentifier((String)argument);
                if (!context.getType(ref).equals((Object)TensorType.empty)) continue;
                context.setType(ref, expressionFunction.getArgumentType(argument));
            }
            context.forgetResolvedTypes();
            TensorType type = this.resolveType(expressionFunction.getBody(), "function '" + function.getKey() + "'", (TypeContext<Reference>)context);
            function.getValue().setReturnType(type);
        }
        if (validate) {
            profile.getSummaryFeatures().forEach(f -> this.resolveType((ExpressionNode)f, "summary feature " + f, (TypeContext<Reference>)context));
            this.ensureValidDouble(profile.getFirstPhaseRanking(), "first-phase expression", context);
            this.ensureValidDouble(profile.getSecondPhaseRanking(), "second-phase expression", context);
            this.ensureValidDouble(profile.getGlobalPhaseRanking(), "global-phase expression", context);
            if ((context.tensorsAreUsed() || profile.isStrict()) && !context.queryFeaturesNotDeclared().isEmpty() && !warnedAbout.containsAll(context.queryFeaturesNotDeclared())) {
                if (profile.isStrict()) {
                    throw new IllegalArgumentException(profile + " is strict but is missing a declaration of inputs " + context.queryFeaturesNotDeclared());
                }
                this.deployLogger.logApplicationPackage(Level.WARNING, "The following inputs used in " + profile + " are not declared and will be interpreted as scalars, not tensors: " + context.queryFeaturesNotDeclared());
                warnedAbout.addAll(context.queryFeaturesNotDeclared());
            }
        }
    }

    private boolean hasUntypedArguments(ExpressionFunction function) {
        return function.arguments().size() > function.argumentTypes().size();
    }

    private TensorType resolveType(RankingExpression expression, String expressionDescription, TypeContext<Reference> context) {
        if (expression == null) {
            return null;
        }
        return this.resolveType(expression.getRoot(), expressionDescription, context);
    }

    private TensorType resolveType(ExpressionNode expression, String expressionDescription, TypeContext<Reference> context) {
        TensorType type;
        try {
            type = expression.type(context);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The " + expressionDescription + " is invalid", e);
        }
        if (type == null) {
            throw new IllegalStateException("Could not determine the type produced by " + expressionDescription);
        }
        return type;
    }

    private void ensureValidDouble(RankingExpression expression, String expressionDescription, TypeContext<Reference> context) {
        if (expression == null) {
            return;
        }
        TensorType type = this.resolveType(expression, expressionDescription, context);
        if (!type.equals((Object)TensorType.empty)) {
            throw new IllegalArgumentException("The " + expressionDescription + " must produce a double (a tensor with no dimensions), but produces " + type);
        }
    }
}

