/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.schema.DocumentOnlySchema;
import com.yahoo.schema.derived.DerivedConfiguration;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.DispatchNodesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.config.search.core.ProtonConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import com.yahoo.vespa.model.container.docproc.DocprocChain;
import com.yahoo.vespa.model.content.DispatchSpec;
import com.yahoo.vespa.model.content.DispatchTuning;
import com.yahoo.vespa.model.content.SearchCoverage;
import com.yahoo.vespa.model.search.DispatchGroup;
import com.yahoo.vespa.model.search.DispatchGroupBuilder;
import com.yahoo.vespa.model.search.DocumentDatabase;
import com.yahoo.vespa.model.search.DocumentSelectionConverter;
import com.yahoo.vespa.model.search.SearchCluster;
import com.yahoo.vespa.model.search.SearchNode;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IndexedSearchCluster
extends SearchCluster
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
SchemaInfoConfig.Producer,
IlscriptsConfig.Producer,
DispatchConfig.Producer,
DispatchNodesConfig.Producer,
ConfigInstance.Producer {
    private String indexingClusterName = null;
    private String indexingChainName = null;
    private DocprocChain indexingChain;
    private Tuning tuning;
    private SearchCoverage searchCoverage;
    private String routingSelector = null;
    private final List<DocumentDatabase> documentDbs = new LinkedList<DocumentDatabase>();
    private final MultipleDocumentDatabasesConfigProducer documentDbsConfigProducer;
    private int searchableCopies = 1;
    private int redundancy = 1;
    private final DispatchGroup rootDispatch;
    private DispatchSpec dispatchSpec;
    private final List<SearchNode> searchNodes = new ArrayList<SearchNode>();
    private final DispatchTuning.DispatchPolicy defaultDispatchPolicy;
    private final double dispatchWarmup;
    private final String summaryDecodePolicy;

    public String getRoutingSelector() {
        return this.routingSelector;
    }

    public IndexedSearchCluster(TreeConfigProducer<AnyConfigProducer> parent, String clusterName, int index, ModelContext.FeatureFlags featureFlags) {
        super(parent, clusterName, index);
        this.documentDbsConfigProducer = new MultipleDocumentDatabasesConfigProducer(this, this.documentDbs);
        this.rootDispatch = new DispatchGroup(this);
        this.defaultDispatchPolicy = DispatchTuning.Builder.toDispatchPolicy(featureFlags.queryDispatchPolicy());
        this.dispatchWarmup = featureFlags.queryDispatchWarmup();
        this.summaryDecodePolicy = featureFlags.summaryDecodePolicy();
    }

    @Override
    protected SearchCluster.IndexingMode getIndexingMode() {
        return SearchCluster.IndexingMode.REALTIME;
    }

    public final boolean hasExplicitIndexingCluster() {
        return this.indexingClusterName != null;
    }

    public final boolean hasExplicitIndexingChain() {
        return this.indexingChainName != null;
    }

    public String getIndexingClusterName() {
        return this.hasExplicitIndexingCluster() ? this.indexingClusterName : this.getClusterName() + ".indexing";
    }

    public String getIndexingChainName() {
        return this.indexingChainName;
    }

    public void setIndexingChainName(String indexingChainName) {
        this.indexingChainName = indexingChainName;
    }

    public void setIndexingClusterName(String name) {
        this.indexingClusterName = name;
    }

    public String getIndexingServiceName() {
        return this.indexingChain.getServiceName();
    }

    public SearchCluster setIndexingChain(DocprocChain chain) {
        this.indexingChain = chain;
        return this;
    }

    public DispatchGroup getRootDispatch() {
        return this.rootDispatch;
    }

    public void addSearcher(SearchNode searcher) {
        this.searchNodes.add(searcher);
        this.rootDispatch.addSearcher(searcher);
    }

    public List<SearchNode> getSearchNodes() {
        return Collections.unmodifiableList(this.searchNodes);
    }

    public int getSearchNodeCount() {
        return this.searchNodes.size();
    }

    public SearchNode getSearchNode(int index) {
        return this.searchNodes.get(index);
    }

    public void setTuning(Tuning tuning) {
        this.tuning = tuning;
    }

    public Tuning getTuning() {
        return this.tuning;
    }

    public void fillDocumentDBConfig(String documentType, ProtonConfig.Documentdb.Builder builder) {
        for (DocumentDatabase sdoc : this.documentDbs) {
            if (!sdoc.getName().equals(documentType)) continue;
            this.fillDocumentDBConfig(sdoc, builder);
            return;
        }
    }

    private void fillDocumentDBConfig(DocumentDatabase sdoc, ProtonConfig.Documentdb.Builder ddbB) {
        ddbB.inputdoctypename(sdoc.getSchemaName()).configid(sdoc.getConfigId());
    }

    public void setRoutingSelector(String selector) {
        this.routingSelector = selector;
        if (this.routingSelector != null) {
            try {
                new DocumentSelectionConverter(this.routingSelector);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid routing selector: " + e.getMessage());
            }
        }
    }

    @Override
    public void defaultDocumentsConfig() {
        if (this.routingSelector == null && !this.getDocumentNames().isEmpty()) {
            Iterator<String> it = this.getDocumentNames().iterator();
            this.routingSelector = it.next();
            StringBuilder sb = new StringBuilder(this.routingSelector);
            while (it.hasNext()) {
                sb.append(" or ").append(it.next());
            }
            this.routingSelector = sb.toString();
        }
    }

    @Override
    public void deriveFromSchemas(DeployState deployState) {
        for (SchemaInfo spec : this.schemas().values()) {
            if (spec.fullSchema() instanceof DocumentOnlySchema) continue;
            DocumentDatabase db = new DocumentDatabase(this, spec.fullSchema().getName(), new DerivedConfiguration(spec.fullSchema(), deployState));
            this.documentDbs.add(db);
        }
    }

    @Override
    public List<DocumentDatabase> getDocumentDbs() {
        return this.documentDbs;
    }

    public boolean hasDocumentDB(String name) {
        for (DocumentDatabase db : this.documentDbs) {
            if (!db.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void setSearchCoverage(SearchCoverage searchCoverage) {
        this.searchCoverage = searchCoverage;
    }

    public void getConfig(DocumentdbInfoConfig.Builder builder) {
        for (DocumentDatabase db : this.documentDbs) {
            DocumentdbInfoConfig.Documentdb.Builder docDb = new DocumentdbInfoConfig.Documentdb.Builder();
            docDb.name(db.getName());
            builder.documentdb(docDb);
        }
    }

    public void getConfig(IndexInfoConfig.Builder builder) {
        this.documentDbsConfigProducer.getConfig(builder);
    }

    public void getConfig(SchemaInfoConfig.Builder builder) {
        this.documentDbsConfigProducer.getConfig(builder);
    }

    public void getConfig(IlscriptsConfig.Builder builder) {
        this.documentDbsConfigProducer.getConfig(builder);
    }

    @Override
    public void getConfig(AttributesConfig.Builder builder) {
        this.documentDbsConfigProducer.getConfig(builder);
    }

    @Override
    public void getConfig(RankProfilesConfig.Builder builder) {
        this.documentDbsConfigProducer.getConfig(builder);
    }

    boolean useFixedRowInDispatch() {
        for (SearchNode node : this.getSearchNodes()) {
            if (node.getNodeSpec().groupIndex() <= 0) continue;
            return true;
        }
        return false;
    }

    public int getSearchableCopies() {
        return this.searchableCopies;
    }

    public void setSearchableCopies(int searchableCopies) {
        this.searchableCopies = searchableCopies;
    }

    public int getRedundancy() {
        return this.redundancy;
    }

    public void setRedundancy(int redundancy) {
        this.redundancy = redundancy;
    }

    public void setDispatchSpec(DispatchSpec dispatchSpec) {
        this.dispatchSpec = dispatchSpec.getNumDispatchGroups() != null ? new DispatchSpec.Builder().setGroups(DispatchGroupBuilder.createDispatchGroups(this.getSearchNodes(), dispatchSpec.getNumDispatchGroups())).build() : dispatchSpec;
    }

    public DispatchSpec getDispatchSpec() {
        return this.dispatchSpec;
    }

    private static DispatchConfig.DistributionPolicy.Enum toDistributionPolicy(DispatchTuning.DispatchPolicy tuning) {
        return switch (tuning) {
            default -> throw new IncompatibleClassChangeError();
            case DispatchTuning.DispatchPolicy.ADAPTIVE -> DispatchConfig.DistributionPolicy.ADAPTIVE;
            case DispatchTuning.DispatchPolicy.ROUNDROBIN -> DispatchConfig.DistributionPolicy.ROUNDROBIN;
            case DispatchTuning.DispatchPolicy.BEST_OF_RANDOM_2 -> DispatchConfig.DistributionPolicy.BEST_OF_RANDOM_2;
            case DispatchTuning.DispatchPolicy.LATENCY_AMORTIZED_OVER_REQUESTS -> DispatchConfig.DistributionPolicy.LATENCY_AMORTIZED_OVER_REQUESTS;
            case DispatchTuning.DispatchPolicy.LATENCY_AMORTIZED_OVER_TIME -> DispatchConfig.DistributionPolicy.LATENCY_AMORTIZED_OVER_TIME;
        };
    }

    public void getConfig(DispatchNodesConfig.Builder builder) {
        for (SearchNode node : this.getSearchNodes()) {
            DispatchNodesConfig.Node.Builder nodeBuilder = new DispatchNodesConfig.Node.Builder();
            nodeBuilder.key(node.getDistributionKey());
            nodeBuilder.group(node.getNodeSpec().groupIndex());
            nodeBuilder.host(node.getHostName());
            nodeBuilder.port(node.getRpcPort());
            builder.node(nodeBuilder);
        }
    }

    public void getConfig(DispatchConfig.Builder builder) {
        if (this.tuning.dispatch.getTopkProbability() != null) {
            builder.topKProbability(this.tuning.dispatch.getTopkProbability().doubleValue());
        }
        if (this.tuning.dispatch.getMinActiveDocsCoverage() != null) {
            builder.minActivedocsPercentage(this.tuning.dispatch.getMinActiveDocsCoverage().doubleValue());
        }
        if (this.tuning.dispatch.getDispatchPolicy() != null) {
            builder.distributionPolicy(IndexedSearchCluster.toDistributionPolicy(this.tuning.dispatch.getDispatchPolicy()));
        } else {
            builder.distributionPolicy(IndexedSearchCluster.toDistributionPolicy(this.defaultDispatchPolicy));
        }
        if (this.tuning.dispatch.getMaxHitsPerPartition() != null) {
            builder.maxHitsPerNode(this.tuning.dispatch.getMaxHitsPerPartition().intValue());
        }
        builder.redundancy((long)this.rootDispatch.getRedundancy());
        if (this.searchCoverage != null) {
            if (this.searchCoverage.getMinimum() != null) {
                builder.minSearchCoverage(this.searchCoverage.getMinimum() * 100.0);
            }
            if (this.searchCoverage.getMinWaitAfterCoverageFactor() != null) {
                builder.minWaitAfterCoverageFactor(this.searchCoverage.getMinWaitAfterCoverageFactor().doubleValue());
            }
            if (this.searchCoverage.getMaxWaitAfterCoverageFactor() != null) {
                builder.maxWaitAfterCoverageFactor(this.searchCoverage.getMaxWaitAfterCoverageFactor().doubleValue());
            }
        }
        builder.warmuptime(this.dispatchWarmup);
        builder.summaryDecodePolicy(this.toSummaryDecoding(this.summaryDecodePolicy));
    }

    private DispatchConfig.SummaryDecodePolicy.Enum toSummaryDecoding(String summaryDecodeType) {
        return switch (summaryDecodeType.toLowerCase()) {
            case "eager" -> DispatchConfig.SummaryDecodePolicy.EAGER;
            case "ondemand", "on-demand" -> DispatchConfig.SummaryDecodePolicy.Enum.ONDEMAND;
            default -> DispatchConfig.SummaryDecodePolicy.Enum.EAGER;
        };
    }

    @Override
    public int getRowBits() {
        return 8;
    }

    @Override
    public String toString() {
        return "Indexing cluster '" + this.getClusterName() + "'";
    }

    public static class MultipleDocumentDatabasesConfigProducer
    extends TreeConfigProducer<MultipleDocumentDatabasesConfigProducer>
    implements AttributesConfig.Producer,
    IndexInfoConfig.Producer,
    IlscriptsConfig.Producer,
    SchemaInfoConfig.Producer,
    RankProfilesConfig.Producer {
        private final List<DocumentDatabase> docDbs;

        private MultipleDocumentDatabasesConfigProducer(TreeConfigProducer<?> parent, List<DocumentDatabase> docDbs) {
            super(parent, "union");
            this.docDbs = docDbs;
        }

        public void getConfig(IndexInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(SchemaInfoConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(IlscriptsConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(AttributesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }

        public void getConfig(RankProfilesConfig.Builder builder) {
            for (DocumentDatabase docDb : this.docDbs) {
                docDb.getConfig(builder);
            }
        }
    }
}

