/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.first;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.List;
import java.util.stream.Stream;

public class RedundancyValidator
extends Validator
implements ChangeValidator {
    @Override
    public void validate(VespaModel model, DeployState deployState) {
        if (!this.shouldValidate(deployState)) {
            return;
        }
        this.clustersWithRedundancyOne(model).forEach(cluster -> this.invalidRedundancy((ContentCluster)cluster, deployState));
    }

    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, DeployState deployState) {
        if (!this.shouldValidate(deployState)) {
            return List.of();
        }
        this.clustersWithRedundancyOne(next).filter(cluster -> !this.hasRedundancyOne(current.getContentClusters().get(cluster.id().value()))).forEach(cluster -> this.invalidRedundancy((ContentCluster)cluster, deployState));
        return List.of();
    }

    private boolean shouldValidate(DeployState deployState) {
        return deployState.isHosted() && deployState.zone().environment().isProduction();
    }

    private Stream<ContentCluster> clustersWithRedundancyOne(VespaModel model) {
        return model.getContentClusters().values().stream().filter(cluster -> this.hasRedundancyOne((ContentCluster)cluster));
    }

    private boolean hasRedundancyOne(ContentCluster cluster) {
        return cluster != null && cluster.redundancy().finalRedundancy() == 1 && cluster.redundancy().groups() == 1;
    }

    private void invalidRedundancy(ContentCluster cluster, DeployState deployState) {
        deployState.validationOverrides().invalid(ValidationId.redundancyOne, cluster + " has redundancy 1, which will cause it to lose data if a node fails. This requires an override on first deployment in a production zone", deployState.now());
    }
}

