/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.content.cluster.ContentCluster;
import java.util.List;

public class RedundancyIncreaseValidator
implements ChangeValidator {
    @Override
    public List<ConfigChangeAction> validate(VespaModel current, VespaModel next, DeployState deployState) {
        for (ContentCluster currentCluster : current.getContentClusters().values()) {
            ContentCluster nextCluster = next.getContentClusters().get(currentCluster.getSubId());
            if (nextCluster == null || this.redundancyOf(nextCluster) <= this.redundancyOf(currentCluster)) continue;
            deployState.validationOverrides().invalid(ValidationId.redundancyIncrease, "Increasing redundancy from " + this.redundancyOf(currentCluster) + " to " + this.redundancyOf(nextCluster) + " in '" + currentCluster + ". This is a safe operation but verify that you have room for a " + this.redundancyOf(nextCluster) + "/" + this.redundancyOf(currentCluster) + "x increase in content size", deployState.now());
        }
        return List.of();
    }

    private int redundancyOf(ContentCluster cluster) {
        return cluster.redundancy().finalRedundancy();
    }
}

