/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin.monitoring;

import ai.vespa.metricsproxy.core.VespaMetrics;
import ai.vespa.metricsproxy.http.ValuesFetcher;
import com.yahoo.vespa.model.admin.monitoring.AutoscalingMetrics;
import com.yahoo.vespa.model.admin.monitoring.DefaultMetrics;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricSet;
import com.yahoo.vespa.model.admin.monitoring.NetworkMetrics;
import com.yahoo.vespa.model.admin.monitoring.SystemMetrics;
import com.yahoo.vespa.model.admin.monitoring.VespaMetricSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MetricsConsumer {
    public static final MetricsConsumer vespa = MetricsConsumer.consumer(VespaMetrics.vespaMetricsConsumerId.id, VespaMetricSet.vespaMetricSet, SystemMetrics.systemMetricSet, NetworkMetrics.networkMetricSet);
    public static final MetricsConsumer defaultConsumer = MetricsConsumer.consumer(ValuesFetcher.defaultMetricsConsumerId.id, DefaultMetrics.defaultMetricSet, SystemMetrics.systemMetricSet);
    public static final MetricsConsumer autoscaling = MetricsConsumer.consumer("autoscaling", AutoscalingMetrics.autoscalingMetricSet);
    public static final MetricsConsumer vespaCloud = MetricsConsumer.consumer("vespa-cloud", VespaMetricSet.vespaMetricSet, SystemMetrics.systemMetricSet, NetworkMetrics.networkMetricSet);
    private final String id;
    private final MetricSet metricSet;

    public MetricsConsumer(String id, MetricSet metricSet) {
        this.id = Objects.requireNonNull(id, "A consumer must have a non-null id.");
        this.metricSet = Objects.requireNonNull(metricSet, "A consumer must have a non-null metric set.");
    }

    public String id() {
        return this.id;
    }

    public MetricSet metricSet() {
        return this.metricSet;
    }

    public Map<String, Metric> metrics() {
        return this.metricSet.getMetrics();
    }

    private static MetricsConsumer consumer(String id, MetricSet ... metricSets) {
        return new MetricsConsumer(id, new MetricSet(id + "-consumer-metrics", List.of(), Arrays.asList(metricSets)));
    }
}

