/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.api.container.ContainerServiceType;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.admin.LogserverContainerCluster;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.component.AccessLogComponent;
import java.util.Optional;

public class LogserverContainer
extends Container {
    public LogserverContainer(TreeConfigProducer<?> parent, DeployState deployState) {
        super(parent, "0", 0, deployState);
        if (deployState.isHosted() && deployState.getProperties().applicationId().instance().isTester()) {
            this.useDynamicPorts();
        }
        LogserverContainerCluster cluster = (LogserverContainerCluster)parent;
        this.addComponent(new AccessLogComponent(cluster, AccessLogComponent.AccessLogType.jsonAccessLog, deployState.featureFlags().logFileCompressionAlgorithm("zstd"), Optional.of(cluster.getName()), true));
    }

    @Override
    public ContainerServiceType myServiceType() {
        return ContainerServiceType.LOGSERVER_CONTAINER;
    }

    @Override
    public String defaultPreload() {
        return "";
    }

    @Override
    protected String jvmOmitStackTraceInFastThrowOption(ModelContext.FeatureFlags featureFlags) {
        return featureFlags.jvmOmitStackTraceInFastThrowOption(ClusterSpec.Type.admin);
    }
}

