/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.cloud.config.LogforwarderConfig;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import java.util.Optional;

public class LogForwarder
extends AbstractService
implements LogforwarderConfig.Producer {
    private final Config config;

    public LogForwarder(TreeConfigProducer<? super LogForwarder> parent, Config config) {
        super(parent, "logforwarder");
        this.config = config;
        this.setProp("clustertype", "hosts");
        this.setProp("clustername", "admin");
    }

    public static Config cfg() {
        return new Config(null, null, null, null);
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
    }

    @Override
    public int getPortCount() {
        return 0;
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.of("exec $ROOT/bin/vespa-logforwarder-start -c " + this.getConfigId());
    }

    public void getConfig(LogforwarderConfig.Builder builder) {
        builder.deploymentServer(this.config.deploymentServer);
        builder.clientName(this.config.clientName);
        if (this.config.splunkHome != null) {
            builder.splunkHome(this.config.splunkHome);
        }
        if (this.config.phoneHomeInterval != null) {
            builder.phoneHomeInterval(this.config.phoneHomeInterval.intValue());
        }
    }

    @Override
    public Optional<String> getPreShutdownCommand() {
        LogforwarderConfig.Builder builder = new LogforwarderConfig.Builder();
        this.getConfig(builder);
        LogforwarderConfig cfg = new LogforwarderConfig(builder);
        String home = cfg.splunkHome();
        String cmd = "$ROOT/bin/vespa-logforwarder-start -S -c " + this.getConfigId();
        return Optional.of(cmd);
    }

    public static class Config {
        public final String deploymentServer;
        public final String clientName;
        public final String splunkHome;
        public final Integer phoneHomeInterval;

        private Config(String ds, String cn, String sh, Integer phi) {
            this.deploymentServer = ds;
            this.clientName = cn;
            this.splunkHome = sh;
            this.phoneHomeInterval = phi;
        }

        public Config withDeploymentServer(String ds) {
            return new Config(ds, this.clientName, this.splunkHome, this.phoneHomeInterval);
        }

        public Config withClientName(String cn) {
            return new Config(this.deploymentServer, cn, this.splunkHome, this.phoneHomeInterval);
        }

        public Config withSplunkHome(String sh) {
            return new Config(this.deploymentServer, this.clientName, sh, this.phoneHomeInterval);
        }

        public Config withPhoneHomeInterval(Integer phi) {
            return new Config(this.deploymentServer, this.clientName, this.splunkHome, phi);
        }
    }
}

