/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Duration {
    private static final Pattern pattern = Pattern.compile("([0-9\\.]+)\\s*([a-z]+)?");
    private static final Map<String, Integer> unitMultiplier = new HashMap<String, Integer>();
    long value;

    public Duration(String value) {
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Illegal duration format: " + value);
        }
        double num = Double.parseDouble(matcher.group(1));
        String unit = matcher.group(2);
        if (unit != null) {
            Integer multiplier = unitMultiplier.get(unit);
            if (multiplier == null) {
                throw new IllegalArgumentException("Unknown time unit: " + unit + " in time value " + value);
            }
            num *= (double)multiplier.intValue();
        } else {
            num *= 1000.0;
        }
        this.value = (long)num;
    }

    public double getSeconds() {
        return (double)this.value / 1000.0;
    }

    public long getMilliSeconds() {
        return this.value;
    }

    static {
        unitMultiplier.put("s", 1000);
        unitMultiplier.put("d", 86400000);
        unitMultiplier.put("ms", 1);
        unitMultiplier.put("m", 60000);
        unitMultiplier.put("h", 3600000);
    }
}

