/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.searchlib.TranslogserverConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import org.w3c.dom.Element;

public class TransactionLogServer
extends AbstractService {
    private final Boolean useFsync;

    public TransactionLogServer(TreeConfigProducer<?> searchNode, String clusterName, Boolean useFsync) {
        super(searchNode, "transactionlogserver");
        this.portsMeta.on(0).tag("tls");
        this.useFsync = useFsync;
        this.setProp("clustername", clusterName);
        this.setProp("clustertype", "search");
    }

    @Override
    public int getPortCount() {
        return 1;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        from.allocatePort("tls");
    }

    int getTlsPort() {
        return this.getRelativePort(0);
    }

    private String getTlsDir() {
        return "tls";
    }

    public void getConfig(TranslogserverConfig.Builder builder) {
        builder.listenport(this.getTlsPort()).basedir(this.getTlsDir());
        if (this.useFsync != null) {
            builder.usefsync(this.useFsync.booleanValue());
        }
    }

    public static class Builder
    extends VespaDomBuilder.DomConfigProducerBuilderBase<TransactionLogServer> {
        private final String clusterName;
        private final Boolean useFsync;

        public Builder(String clusterName, Boolean useFsync) {
            this.clusterName = clusterName;
            this.useFsync = useFsync;
        }

        @Override
        protected TransactionLogServer doBuild(DeployState deployState, TreeConfigProducer<AnyConfigProducer> ancestor, Element producerSpec) {
            return new TransactionLogServer(ancestor, this.clusterName, this.useFsync);
        }
    }
}

