/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.search;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.prelude.fastsearch.DocumentdbInfoConfig;
import com.yahoo.schema.derived.SchemaInfo;
import com.yahoo.search.config.IndexInfoConfig;
import com.yahoo.search.config.SchemaInfoConfig;
import com.yahoo.vespa.config.search.AttributesConfig;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import com.yahoo.vespa.configdefinition.IlscriptsConfig;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class SearchCluster
extends TreeConfigProducer<AnyConfigProducer>
implements DocumentdbInfoConfig.Producer,
IndexInfoConfig.Producer,
IlscriptsConfig.Producer,
SchemaInfoConfig.Producer {
    private final String clusterName;
    private int index;
    private Double queryTimeout;
    private Double visibilityDelay = 0.0;
    private final Map<String, SchemaInfo> schemas = new LinkedHashMap<String, SchemaInfo>();

    public SearchCluster(TreeConfigProducer<?> parent, String clusterName, int index) {
        super(parent, "cluster." + clusterName);
        this.clusterName = clusterName;
        this.index = index;
    }

    public void add(SchemaInfo schema) {
        this.schemas.put(schema.name(), schema);
    }

    public Map<String, SchemaInfo> schemas() {
        return Collections.unmodifiableMap(this.schemas);
    }

    public abstract void deriveFromSchemas(DeployState var1);

    public List<String> getDocumentNames() {
        return this.schemas.values().stream().map(schema -> schema.fullSchema().getDocument().getDocumentName().getName()).toList();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public final String getIndexingModeName() {
        return this.getIndexingMode().getName();
    }

    public final boolean isStreaming() {
        return this.getIndexingMode() == IndexingMode.STREAMING;
    }

    public final void setQueryTimeout(Double to) {
        this.queryTimeout = to;
    }

    public final void setVisibilityDelay(double delay) {
        this.visibilityDelay = delay;
    }

    protected abstract IndexingMode getIndexingMode();

    public final Double getVisibilityDelay() {
        return this.visibilityDelay;
    }

    public final Double getQueryTimeout() {
        return this.queryTimeout;
    }

    public abstract int getRowBits();

    public final void setClusterIndex(int index) {
        this.index = index;
    }

    public final int getClusterIndex() {
        return this.index;
    }

    public abstract void defaultDocumentsConfig();

    public abstract void getConfig(AttributesConfig.Builder var1);

    public abstract void getConfig(RankProfilesConfig.Builder var1);

    public String toString() {
        return "search-capable cluster '" + this.clusterName + "'";
    }

    public static final class IndexingMode {
        public static final IndexingMode REALTIME = new IndexingMode("REALTIME");
        public static final IndexingMode STREAMING = new IndexingMode("STREAMING");
        private final String name;

        private IndexingMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "indexingmode: " + this.name;
        }
    }
}

