/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.search;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.vespa.model.container.search.SemanticRules;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;

public class SemanticRuleBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SemanticRules build(ApplicationPackage applicationPackage) {
        SemanticRules semanticRules;
        List ruleBaseFiles = null;
        try {
            ruleBaseFiles = applicationPackage.getFiles(ApplicationPackage.RULES_DIR, "sr");
            semanticRules = new SemanticRules(ruleBaseFiles.stream().map(this::toRuleBaseConfigView).toList());
        }
        catch (Throwable throwable) {
            NamedReader.closeAll(ruleBaseFiles);
            throw throwable;
        }
        NamedReader.closeAll((List)ruleBaseFiles);
        return semanticRules;
    }

    private SemanticRules.RuleBase toRuleBaseConfigView(NamedReader reader) {
        try {
            String ruleBaseString = IOUtils.readAll((Reader)reader.getReader());
            boolean isDefault = ruleBaseString.contains("@default");
            return new SemanticRules.RuleBase(this.toName(reader.getName()), isDefault, ruleBaseString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load rules bases", e);
        }
    }

    private String toName(String fileName) {
        String shortName = new File(fileName).getName();
        return shortName.substring(0, shortName.length() - ".sr".length());
    }
}

